/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.editor.textpage.IReconcileListener;
import aurora.ide.helpers.DialogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class XmlReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ProjectionViewer mSourceViewer;
    private List<IReconcileListener> listeners = new ArrayList<IReconcileListener>();

    public XmlReconcilingStrategy(ISourceViewer sourceViewer) {
        this.mSourceViewer = (ProjectionViewer)sourceViewer;
    }

    public boolean addListener(IReconcileListener l) {
        return this.listeners.add(l);
    }

    public void reconcile(IRegion partition) {
        this.noticeListener();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.noticeListener();
    }

    public void setDocument(IDocument document) {
        this.noticeListener();
    }

    private void noticeListener() {
        if (!this.listeners.isEmpty()) {
            ListIterator<IReconcileListener> it = this.listeners.listIterator();
            while (it.hasNext()) {
                try {
                    ((IReconcileListener)it.next()).reconcile();
                }
                catch (Throwable e) {
                    DialogUtil.showExceptionMessageBox(e);
                }
            }
        }
    }

    public void initialReconcile() {
        this.noticeListener();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

