/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.editor.textpage.BracesMatch;
import aurora.ide.helpers.DialogUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;

public class XMLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer textView;
    private ISourceViewer sourceViewer;
    public static final String AnnotationType = "aurora.ide.word.highlight";
    private List annotatioList = new LinkedList();
    private List offsetList = new LinkedList();
    int offset;
    private String keyWord;
    private IAnnotationModel annotationModel;
    private BracesMatch braceMatch;

    public XMLDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        this.sourceViewer = sourceViewer;
        this.braceMatch = new BracesMatch(sourceViewer);
        this.addListner(sourceViewer);
    }

    private void addListner(ISourceViewer sourceViewer) {
        sourceViewer.getTextWidget().addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                try {
                    XMLDoubleClickStrategy.this.braceMatch.compute(event.caretOffset);
                }
                catch (BadLocationException e) {
                    DialogUtil.logErrorException(e);
                }
                if (XMLDoubleClickStrategy.this.keyWord == null || "".equals(XMLDoubleClickStrategy.this.keyWord)) {
                    return;
                }
                int caretOffset = event.caretOffset - XMLDoubleClickStrategy.this.keyWord.length();
                if (XMLDoubleClickStrategy.this.offsetList.contains(new Integer(caretOffset))) {
                    return;
                }
                XMLDoubleClickStrategy.this.clearHistory();
            }
        });
    }

    public void doubleClicked(ITextViewer part) {
        this.annotationModel = this.getAnnotationModel();
        this.clearHistory();
        this.offset = part.getSelectedRange().x;
        if (this.offset < 0) {
            return;
        }
        this.textView = part;
        this.selectWord(this.offset);
    }

    private IAnnotationModel getAnnotationModel() {
        if (this.annotationModel != null) {
            return this.annotationModel;
        }
        this.annotationModel = this.sourceViewer.getAnnotationModel();
        if (this.annotationModel == null) {
            this.annotationModel = new AnnotationModel();
            this.annotationModel.connect(this.sourceViewer.getDocument());
        }
        return this.annotationModel;
    }

    protected boolean selectComment(int caretPos) {
        int startPos;
        int pos;
        block8: {
            int c;
            IDocument doc;
            block7: {
                doc = this.textView.getDocument();
                pos = caretPos;
                c = 32;
                while (pos >= 0) {
                    c = doc.getChar(pos);
                    if (c == 92) {
                        pos -= 2;
                        continue;
                    }
                    if (c == 13 || c == 34) break;
                    --pos;
                }
                if (c == 34) break block7;
                return false;
            }
            try {
                startPos = pos;
                pos = caretPos;
                int length = doc.getLength();
                c = 32;
                while (pos < length) {
                    c = doc.getChar(pos);
                    if (c == 13 || c == 34) break;
                    ++pos;
                }
                if (c == 34) break block8;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        int endPos = pos;
        int offset = startPos + 1;
        int len = endPos - offset;
        this.textView.setSelectedRange(offset, len);
        return true;
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.textView.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            int offset = startPos + 1;
            int wordLength = endPos - offset;
            this.keyWord = this.textView.getDocument().get(offset, wordLength);
            this.setHighLight(this.keyWord);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void setHighLight(String keyword) {
        String line = this.textView.getTextWidget().getText();
        int cursor = -1;
        while ((cursor = line.indexOf(keyword, cursor + 1)) >= 0) {
            this.createAnnotation(cursor);
        }
    }

    protected void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.textView.setSelectedRange(offset, length);
    }

    private void createAnnotation(int offset) {
        Position pos = new Position(offset, this.keyWord.length());
        Annotation annotation = new Annotation(AnnotationType, false, this.keyWord);
        this.annotationModel.addAnnotation(annotation, pos);
        this.annotatioList.add(annotation);
        this.offsetList.add(new Integer(offset));
    }

    private void clearHistory() {
        if (this.offsetList.size() == 0) {
            return;
        }
        Iterator it = this.annotatioList.iterator();
        while (it.hasNext()) {
            this.annotationModel.removeAnnotation((Annotation)it.next());
        }
        this.annotatioList.clear();
        this.offsetList.clear();
    }
}

