/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.builder.IntimeBuilder;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.JavaScriptAutoIndentStrategy;
import aurora.ide.editor.textpage.NonRuleBasedDamagerRepairer;
import aurora.ide.editor.textpage.ProjectionReconcile;
import aurora.ide.editor.textpage.XMLAutoEditStrategy;
import aurora.ide.editor.textpage.XMLDoubleClickStrategy;
import aurora.ide.editor.textpage.XmlErrorReconcile;
import aurora.ide.editor.textpage.XmlReconcilingStrategy;
import aurora.ide.editor.textpage.contentassist.TagContentAssistProcessor;
import aurora.ide.editor.textpage.format.DefaultFormattingStrategy;
import aurora.ide.editor.textpage.format.DocTypeFormattingStrategy;
import aurora.ide.editor.textpage.format.PIFormattingStrategy;
import aurora.ide.editor.textpage.format.TextFormattingStrategy;
import aurora.ide.editor.textpage.format.XMLFormattingStrategy;
import aurora.ide.editor.textpage.hover.HoverInformationControlCreator;
import aurora.ide.editor.textpage.hover.TextHover;
import aurora.ide.editor.textpage.hyperlinks.FileHyperlinkDetector;
import aurora.ide.editor.textpage.js.validate.JSValidator;
import aurora.ide.editor.textpage.quickfix.QuickAssistProcessor;
import aurora.ide.editor.textpage.scanners.JSEditorCodeScanner;
import aurora.ide.editor.textpage.scanners.XMLScanner;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private JSEditorCodeScanner cdataScanner;
    private ColorManager colorManager;

    public XMLConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "XML_COMMENT", "XML_PI", "XML_DOCTYPE", "XML_START_TAG", "XML_END_TAG", "XML_CDATA"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy(sourceViewer, contentType);
        }
        return this.doubleClickStrategy;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("XML_CDATA")) {
            return new IAutoEditStrategy[]{new JavaScriptAutoIndentStrategy()};
        }
        IAutoEditStrategy[] aes = super.getAutoEditStrategies(sourceViewer, contentType);
        IAutoEditStrategy[] aes2 = new IAutoEditStrategy[aes.length + 1];
        System.arraycopy(aes, 0, aes2, 0, aes.length);
        aes2[aes.length] = new XMLAutoEditStrategy();
        return aes2;
    }

    protected JSEditorCodeScanner getCDataScanner() {
        if (this.cdataScanner == null) {
            this.cdataScanner = new JSEditorCodeScanner(this.colorManager);
            this.cdataScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IColorConstants.CDATA_TEXT))));
        }
        return this.cdataScanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "XML_START_TAG");
        reconciler.setRepairer((IPresentationRepairer)dr, "XML_START_TAG");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "XML_END_TAG");
        reconciler.setRepairer((IPresentationRepairer)dr, "XML_END_TAG");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "XML_DOCTYPE");
        reconciler.setRepairer((IPresentationRepairer)dr, "XML_DOCTYPE");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "XML_PI");
        reconciler.setRepairer((IPresentationRepairer)dr, "XML_PI");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCDataScanner());
        reconciler.setDamager((IPresentationDamager)dr, "XML_CDATA");
        reconciler.setRepairer((IPresentationRepairer)dr, "XML_CDATA");
        TextAttribute textAttribute = new TextAttribute(this.colorManager.getColor(IColorConstants.XML_COMMENT));
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(textAttribute);
        reconciler.setDamager((IPresentationDamager)ndr, "XML_COMMENT");
        reconciler.setRepairer((IPresentationRepairer)ndr, "XML_COMMENT");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new TagContentAssistProcessor(this.getXMLTagScanner()), "XML_START_TAG");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new TagContentAssistProcessor(this.getXMLTagScanner()), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(200);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        assistant.setInformationControlCreator((IInformationControlCreator)new HoverInformationControlCreator());
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        XMLFormattingStrategy formattingStrategy = new XMLFormattingStrategy();
        DefaultFormattingStrategy defaultStrategy = new DefaultFormattingStrategy();
        TextFormattingStrategy textStrategy = new TextFormattingStrategy();
        DocTypeFormattingStrategy doctypeStrategy = new DocTypeFormattingStrategy();
        PIFormattingStrategy piStrategy = new PIFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)defaultStrategy, "__dftl_partition_content_type");
        formatter.setFormattingStrategy((IFormattingStrategy)doctypeStrategy, "XML_DOCTYPE");
        formatter.setFormattingStrategy((IFormattingStrategy)piStrategy, "XML_PI");
        formatter.setFormattingStrategy((IFormattingStrategy)textStrategy, "XML_CDATA");
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "XML_START_TAG");
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "XML_END_TAG");
        return formatter;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new FileHyperlinkDetector()};
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public static RGB getTokenType(IToken token) {
        if (token == null || !(token instanceof TextAttribute)) {
            return null;
        }
        TextAttribute textAttribute = (TextAttribute)token.getData();
        return textAttribute.getForeground().getRGB();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        XmlReconcilingStrategy strategy = new XmlReconcilingStrategy(sourceViewer);
        strategy.addListener(new XmlErrorReconcile(sourceViewer));
        strategy.addListener(new ProjectionReconcile((ProjectionViewer)sourceViewer));
        strategy.addListener(new IntimeBuilder(sourceViewer));
        strategy.addListener(new JSValidator(sourceViewer));
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        return new TextViewerUndoManager(generalTextStore.getInt("undoHistorySize"));
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant qaa = new QuickAssistAssistant();
        qaa.setInformationControlCreator((IInformationControlCreator)new HoverInformationControlCreator());
        QuickAssistProcessor qap = new QuickAssistProcessor();
        qaa.setQuickAssistProcessor((IQuickAssistProcessor)qap);
        return qaa;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        TextHover th = new TextHover(sourceViewer);
        return th;
    }
}

