/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.editor.textpage.IReconcileListener;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.SystemException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import uncertain.composite.CompositeMap;

public class ProjectionReconcile
implements IReconcileListener {
    private Annotation[] oldProjectionAnnotations;
    private ProjectionAnnotationModel projectionAM;
    private ProjectionViewer sourceViewer;
    private List oldPositions;

    public ProjectionReconcile(ProjectionViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public void reconcile() {
        this.projectionAM = this.sourceViewer.getProjectionAnnotationModel();
        if (this.projectionAM == null) {
            return;
        }
        List positions = new LinkedList();
        try {
            positions = this.calculatePositions();
        }
        catch (ApplicationException e) {
            this.updateFoldingStructure(null);
        }
        if (!this.isListEqual(positions, this.oldPositions)) {
            this.updateFoldingStructure(positions);
            this.oldPositions = positions;
        }
    }

    private boolean isListEqual(List one, List two) {
        if (one == null && two == null) {
            return true;
        }
        return one != null && one.equals(two);
    }

    protected List calculatePositions() throws ApplicationException {
        LinkedList<Position> positions = new LinkedList<Position>();
        String content = this.sourceViewer.getDocument().get();
        CompositeMap root = CompositeMapUtil.loaderFromString(content);
        if (root == null) {
            return null;
        }
        try {
            if (root.getLocation().getEndLine() > root.getLocation().getStartLine()) {
                positions.add(this.createPosition(root.getLocation().getRange()));
            }
            this.iteratorNodes(root, positions);
        }
        catch (BadLocationException e) {
            throw new SystemException(e);
        }
        return positions;
    }

    private void iteratorNodes(CompositeMap node, List positions) throws BadLocationException {
        if (node == null || node.getChildIterator() == null) {
            return;
        }
        Iterator it = node.getChildIterator();
        while (it.hasNext()) {
            CompositeMap child = (CompositeMap)it.next();
            if (child.getLocation().getEndLine() - child.getLocation().getStartLine() > 4) {
                positions.add(this.createPosition(child.getLocation().getRange()));
            }
            this.iteratorNodes(child, positions);
        }
    }

    private Position createPosition(int[] location) throws BadLocationException {
        int startLine = location[0] - 1;
        int startColumn = location[1];
        int endLine = location[2] - 1;
        int endColumn = location[3];
        int beginOffset = this.sourceViewer.getDocument().getLineOffset(startLine) + startColumn;
        int endOffset = this.sourceViewer.getDocument().getLineOffset(endLine) + endColumn;
        return new Position(beginOffset, endOffset - beginOffset);
    }

    public void updateFoldingStructure(List positions) {
        if (this.projectionAM == null) {
            return;
        }
        if (positions == null) {
            return;
        }
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap newAnnotations = new HashMap();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.projectionAM.modifyAnnotations(this.oldProjectionAnnotations, newAnnotations, null);
        this.oldProjectionAnnotations = annotations;
    }
}

