/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.outline;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.outline.OutlineParser;
import aurora.ide.editor.outline.OutlineTree;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.xml.sax.SAXException;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;

public class TextOutlinePage
extends ContentOutlinePage {
    protected TextPage editor;
    private Selected selected = new Selected();
    private static List<String> arrays = new ArrayList<String>();

    public TextOutlinePage(IEditorPart activeEditor) {
        this.editor = (TextPage)activeEditor;
        IDocument inputDocument = this.editor.getInputDocument();
        inputDocument.addDocumentListener((IDocumentListener)new DocumentListener());
        if (arrays.size() <= 0) {
            ISchemaManager schemaManager = LoadSchemaManager.getSchemaManager();
            for (Object obj : schemaManager.getAllTypes()) {
                if (!(obj instanceof Element)) continue;
                this.initArray((Element)obj);
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.selected);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.getTreeViewer().setContentProvider((IContentProvider)new OutlineContentProvider());
        this.getTreeViewer().setInput((Object)this.loadTree());
        Action collapse = new Action("aurora.outline", 0){

            public void run() {
                TextOutlinePage.this.getTreeViewer().collapseAll();
            }
        };
        collapse.setToolTipText("Collapse All");
        collapse.setImageDescriptor(AuroraPlugin.getImageDescriptor("icons/collapseall.gif"));
        this.getSite().getActionBars().getToolBarManager().add((IAction)collapse);
        super.setActionBars(this.getSite().getActionBars());
    }

    private void initArray(Element ele) {
        if (ele.isArray()) {
            arrays.add(ele.getLocalName());
        }
        if (ele.getChilds() == null) {
            return;
        }
        for (Object obj : ele.getChilds()) {
            if (!(obj instanceof Element)) continue;
            this.initArray((Element)obj);
        }
    }

    private OutlineTree loadTree() {
        IDocument document = this.editor.getInputDocument();
        OutlineParser p = new OutlineParser(document.get());
        try {
            p.parser();
            return p.getTree();
        }
        catch (ParserConfigurationException e) {
            LogUtil.getInstance().logError(e.getMessage(), e);
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            LogUtil.getInstance().logError(e.getMessage(), e);
        }
        return null;
    }

    public void selectNode(int offset) {
        if (this.getTreeViewer() == null) {
            return;
        }
        OutlineTree root = (OutlineTree)this.getTreeViewer().getInput();
        OutlineTree tree = this.getTree(root == null ? null : root.getChild(0), offset);
        if (tree == null) {
            if (root != null && root.getChild(0) != null) {
                tree = root.getChild(0);
            } else {
                return;
            }
        }
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.selected);
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)tree));
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.selected);
    }

    private OutlineTree getTree(OutlineTree tree, int offset) {
        if (tree == null) {
            return null;
        }
        if (tree.getRegion() != null) {
            if (tree.getRegion().getOffset() <= offset && tree.getRegion().getOffset() + tree.getRegion().getLength() + 1 > offset) {
                return tree;
            }
            return null;
        }
        if (tree.getStartRegion().getOffset() <= offset && tree.getEndRegion().getOffset() + tree.getEndRegion().getLength() + 2 > offset) {
            for (OutlineTree child : tree.getChildren()) {
                OutlineTree t = this.getTree(child, offset);
                if (t == null) continue;
                return t;
            }
        } else {
            return null;
        }
        return tree;
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    private void refresh(OutlineTree tree, OutlineTree input) {
        if (tree == null || input == null) {
            return;
        }
        if (!this.eq(tree, input)) {
            if (this.eq(tree.getText(), input.getText()) && this.eq(tree.getOther(), input.getOther())) {
                input.copy(tree);
            } else {
                input.copy(tree);
                this.getTreeViewer().refresh((Object)input);
            }
        }
        if (tree.getChildrenCount() != input.getChildrenCount()) {
            input.removeAll();
            int i = 0;
            while (i < tree.getChildrenCount()) {
                input.add(tree.getChild(i));
                ++i;
            }
            this.getTreeViewer().refresh((Object)input);
        } else {
            int i = 0;
            while (i < tree.getChildrenCount()) {
                this.refresh(tree.getChild(i), input.getChild(i));
                ++i;
            }
        }
    }

    private Image getOutlineTreeImage(OutlineTree tree) {
        if ("array".equals(tree.getImage())) {
            return ImagesUtils.getImage("array.gif");
        }
        if ("script".equals(tree.getImage())) {
            return ImagesUtils.getImage("script.png");
        }
        if ("method".equals(tree.getImage())) {
            return ImagesUtils.getImage("method.gif");
        }
        if ("variable".equals(tree.getImage())) {
            return ImagesUtils.getImage("variable.gif");
        }
        String defaultPath = LocaleMessage.getString("element.icon");
        return ImagesUtils.getImage("element.gif");
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (TextOutlinePage.this.getTreeViewer() == null || TextOutlinePage.this.getTreeViewer().getTree().isDisposed()) {
                return;
            }
            OutlineTree tree = TextOutlinePage.this.loadTree();
            if (tree == null) {
                return;
            }
            if (TextOutlinePage.this.getTreeViewer().getInput() == null) {
                TextOutlinePage.this.getTreeViewer().setInput((Object)tree);
            } else {
                TextOutlinePage.this.refresh(tree, (OutlineTree)TextOutlinePage.this.getTreeViewer().getInput());
            }
        }
    }

    class OutlineContentProvider
    implements ITreeContentProvider {
        OutlineContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((OutlineTree)inputElement).getChildren().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return ((OutlineTree)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((OutlineTree)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((OutlineTree)element).getChildren().size() > 0;
        }
    }

    class OutlineLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        OutlineLabelProvider() {
        }

        public String getText(Object obj) {
            String name = ((OutlineTree)obj).getText();
            int loc = name.indexOf(":");
            if (loc >= 0 && arrays.contains(name.substring(loc + 1))) {
                ((OutlineTree)obj).setOther("[" + ((OutlineTree)obj).getChildrenCount() + "]");
            }
            return obj.toString();
        }

        public Image getImage(Object element) {
            String name = ((OutlineTree)element).getOther();
            if (name.matches("\\[\\d+\\]")) {
                return ImagesUtils.getImage("array.gif");
            }
            return TextOutlinePage.this.getOutlineTreeImage((OutlineTree)element);
        }
    }

    class Selected
    implements ISelectionChangedListener {
        Selected() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeSelection selection = (TreeSelection)event.getSelection();
            OutlineTree lt = (OutlineTree)selection.getFirstElement();
            if (lt == null) {
                return;
            }
            IRegion region = lt.getStartRegion();
            TextSelection tt = new TextSelection(region.getOffset(), region.getLength());
            TextOutlinePage.this.editor.getEditorSite().getSelectionProvider().setSelection((ISelection)tt);
        }
    }
}

