/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.outline;

import aurora.ide.editor.outline.OutlineTree;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class OutlineParser
extends DefaultHandler2 {
    private OutlineTree root;
    private OutlineTree tree;
    private int offset = 0;
    private String source = null;
    private Stack<OutlineTree> stack = new Stack();

    public OutlineParser(String source) {
        Assert.isNotNull((Object)source);
        this.setSource(source);
        this.root = new OutlineTree();
        this.stack.add(this.root);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int end;
        this.tree = new OutlineTree();
        this.stack.peek().add(this.tree);
        this.stack.push(this.tree);
        this.tree.setText(qName);
        this.tree.setOther(this.getValue(attributes));
        this.offset = this.source.indexOf("<" + qName, this.offset) + 1;
        this.tree.setStartRegion((IRegion)new Region(this.offset, qName.length()));
        int loc = qName.indexOf(":");
        String name = qName;
        if (loc >= 0) {
            name = qName.substring(loc + 1);
        }
        if ("script".equalsIgnoreCase(name) || "style".equalsIgnoreCase(name)) {
            this.tree.setImage("script");
        }
        if ((end = this.source.indexOf("/>", this.offset)) > this.source.indexOf("<", this.offset) || end < 0) {
            this.offset += qName.length();
        } else {
            int start = this.source.lastIndexOf("<", this.offset);
            int length = this.source.indexOf("/>", this.offset) + 2 - start;
            if (length > 0) {
                this.tree.setRegion((IRegion)new Region(start, length));
            }
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.offset = this.source.indexOf("-->", this.offset);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if ("script".equalsIgnoreCase(this.stack.peek().getText())) {
            Parser p = new Parser();
            AstRoot ast = null;
            try {
                ast = p.parse(new String(ch, start, length), "", 0);
            }
            catch (EvaluatorException e) {
                return;
            }
            for (Node node : ast.getStatements()) {
                if (node instanceof VariableDeclaration) {
                    this.createVariableNode((VariableDeclaration)node);
                    continue;
                }
                if (!(node instanceof FunctionNode)) continue;
                this.createFunctionNode((FunctionNode)node);
            }
        } else if ("style".equalsIgnoreCase(this.stack.peek().getText())) {
            this.stack.peek().setImage("script");
        }
    }

    private void createVariableNode(VariableDeclaration node) {
        this.offset = this.source.indexOf("var", this.offset);
        for (VariableInitializer v : node.getVariables()) {
            String name = v.getTarget().getString();
            int start = this.source.indexOf(name, this.offset);
            int length = v.toSource().length();
            OutlineTree t = new OutlineTree();
            t.setText(name);
            t.setOther("");
            t.setImage("variable");
            t.setRegion((IRegion)new Region(start, length + 1));
            t.setStartRegion((IRegion)new Region(start, name.length()));
            t.setEndRegion((IRegion)new Region(start, name.length()));
            this.stack.peek().add(t);
            this.offset += length;
        }
    }

    private void createFunctionNode(FunctionNode node) {
        this.offset = this.source.indexOf("function", this.offset);
        String name = node.getName();
        int lineno = node.getEndLineno() - node.getBaseLineno();
        int len = node.getLength() + lineno;
        OutlineTree t = new OutlineTree();
        t.setStartRegion((IRegion)new Region(this.source.indexOf(name, this.offset), name.length()));
        t.setEndRegion((IRegion)new Region(t.getStartRegion().getOffset(), t.getStartRegion().getLength()));
        t.setRegion((IRegion)new Region(this.offset, len));
        t.setText(name);
        String param = "";
        int i = 0;
        while (i < node.getParams().size() - 1) {
            param = String.valueOf(param) + ((AstNode)node.getParams().get(i)).getString() + ", ";
            ++i;
        }
        if (node.getParams().size() > 0) {
            param = String.valueOf(param) + ((AstNode)node.getParams().get(node.getParams().size() - 1)).getString();
        }
        if ("".equals(param)) {
            param = " ";
        }
        t.setOther("(" + param + ")");
        t.setImage("method");
        this.stack.peek().add(t);
        this.offset += len;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.offset = this.stack.peek().getRegion() == null ? this.source.indexOf("</" + qName, this.offset) + 2 : this.source.indexOf(qName, this.offset);
        this.stack.pop().setEndRegion((IRegion)new Region(this.offset, qName.length()));
        this.offset += qName.length();
    }

    public void endDocument() throws SAXException {
        this.source = null;
        this.stack.clear();
    }

    public OutlineTree getTree() {
        return this.root;
    }

    private String getValue(Attributes attributes) {
        String[] values = new String[]{"id", "name", "type", "field"};
        int i = 0;
        while (i < attributes.getLength()) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase(attributes.getQName(i))) {
                    return "(" + attributes.getValue(attributes.getQName(i)) + ")";
                }
                ++n2;
            }
            ++i;
        }
        return "";
    }

    public void parser() throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        ByteArrayInputStream is = new ByteArrayInputStream(this.source.getBytes("utf-8"));
        try {
            parser.parse((InputStream)is, (DefaultHandler)this);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

