/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.outline;

import aurora.ide.editor.textpage.TextPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class BaseOutlinePage
extends Page
implements IContentOutlinePage {
    private IContentOutlinePage activePage;
    private IEditorPart activeEditor;
    private Composite control;

    public void setActiveEditor(IEditorPart editor) {
        IPageSite site;
        if (this.activePage != null && this.activePage.getControl() != null) {
            this.activePage.getControl().dispose();
        }
        if ((site = this.getSite()) != null) {
            IActionBars actions = site.getActionBars();
            actions.getToolBarManager().removeAll();
            actions.getMenuManager().removeAll();
            actions.updateActionBars();
        }
        if (editor instanceof TextPage) {
            this.activeEditor = editor;
            this.activePage = (IContentOutlinePage)editor.getAdapter(IContentOutlinePage.class);
            if (this.control != null && this.activePage != null) {
                this.initActivePage();
                this.activePage.createControl(this.control);
                this.activePage.setActionBars(this.getSite().getActionBars());
                this.getSite().getActionBars().updateActionBars();
                this.control.layout();
            }
        }
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout());
        if (this.activePage != null) {
            this.initActivePage();
            this.activePage.createControl(this.control);
        }
    }

    private void initActivePage() {
        IPageBookViewPage pageBook;
        IPageSite site = this.getSite();
        if (site == null) {
            return;
        }
        IActionBars actions = site.getActionBars();
        actions.getToolBarManager().removeAll();
        actions.getMenuManager().removeAll();
        actions.updateActionBars();
        if (this.activePage instanceof IPageBookViewPage && (pageBook = (IPageBookViewPage)this.activePage).getSite() == null) {
            try {
                pageBook.init(this.getSite());
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        if (this.activePage != null && this.activePage.getControl() != null && !this.activePage.getControl().isDisposed()) {
            this.activePage.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.activePage != null) {
            this.activePage.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.activePage != null) {
            return this.activePage.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.activePage != null) {
            this.activePage.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.activePage != null) {
            this.activePage.setSelection(selection);
        }
    }

    public IContentOutlinePage getActivePage() {
        return this.activePage;
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }
}

