/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.editorInput;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class PathEditorInput
implements IPathEditorInput {
    public static final Path UNTITLED_PATH = new Path("Untitled.uip");
    private IPath fPath;

    public PathEditorInput(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.fPath = path;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathEditorInput)) {
            return false;
        }
        PathEditorInput other = (PathEditorInput)obj;
        if (this.isUntitled() || other.isUntitled()) {
            return false;
        }
        return this.fPath.equals((Object)other.fPath);
    }

    public boolean exists() {
        return this.fPath.toFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fPath.toString());
    }

    public String getName() {
        return this.fPath.toString();
    }

    public String getToolTipText() {
        return this.fPath.makeRelative().toOSString();
    }

    public IPath getPath() {
        return this.fPath;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setPath(IPath path) {
        this.fPath = path;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean isUntitled() {
        return UNTITLED_PATH.equals((Object)this.fPath);
    }
}

