/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor;

import aurora.ide.helpers.DialogUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.EditorPart;

public class InputFileListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private EditorPart editor;

    public InputFileListener(EditorPart editor) {
        this.editor = editor;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                DialogUtil.logErrorException(e);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            IEditorInput editorInput = this.editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)editorInput).getFile())) {
                if (delta.getKind() == 2 || delta.getKind() == 262144) {
                    this.closeEditor();
                }
                return false;
            }
        }
        return true;
    }

    private void closeEditor() {
        Display display = this.editor.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                InputFileListener.this.editor.getSite().getPage().closeEditor((IEditorPart)InputFileListener.this.editor, false);
            }
        });
    }
}

