/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.editor.BaseCompositeMapViewer;
import aurora.ide.editor.CompositeMapPage;
import aurora.ide.editor.ScreenUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class CompositeMapTreePage
extends CompositeMapPage {
    private CompositeMap data;
    protected BaseCompositeMapViewer baseCompositeMapPage;
    Composite shell;

    public CompositeMapTreePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.shell = form.getBody();
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        if (this.data == null) {
            try {
                CompositeLoader loader = AuroraResourceUtil.getCompsiteLoader();
                this.data = loader.loadByFile(this.getFile().getAbsolutePath());
            }
            catch (IOException e) {
                DialogUtil.logErrorException(e);
            }
            catch (SAXException e) {
                String emptyExcption = "Premature end of file";
                if (e.getMessage() != null && e.getMessage().indexOf(emptyExcption) != -1) {
                    this.data = ScreenUtil.createScreenTopNode();
                    ((CommentCompositeMap)this.data).setComment("\u672c\u6587\u4ef6\u4e3a\u7a7a,\u73b0\u5728\u5185\u5bb9\u4e3a\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa,\u8bf7\u4fee\u6539\u5e76\u4fdd\u5b58");
                }
                return;
            }
        }
        try {
            this.createContent(this.shell);
        }
        catch (ApplicationException e) {
            DialogUtil.logErrorException(e);
        }
    }

    protected File getFile() {
        IFile ifile = ((IFileEditorInput)this.getEditor().getEditorInput()).getFile();
        String fileName = AuroraResourceUtil.getIfileLocalPath(ifile);
        return new File(fileName);
    }

    protected void createContent(Composite shell) throws ApplicationException {
        this.baseCompositeMapPage = new BaseCompositeMapViewer(this, this.data);
        this.baseCompositeMapPage.createFormContent(shell);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            File file = this.getFile();
            CommentXMLOutputter.saveToFile(file, this.data);
            super.doSave(monitor);
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    public void refresh(boolean dirty) {
        this.baseCompositeMapPage.refresh(false);
        super.refresh(dirty);
    }

    public CompositeMap getData() {
        return this.data;
    }

    public TreeViewer getTreeViewer() {
        return this.baseCompositeMapPage.getTreeViewer();
    }

    public CompositeMap getSelection() {
        return this.baseCompositeMapPage.getSelection();
    }

    public void setData(CompositeMap content) {
        this.data = content;
    }

    public boolean isFormContendCreated() {
        return this.baseCompositeMapPage != null;
    }

    public void refreshFormContent(CompositeMap data) {
        this.data = data;
        this.baseCompositeMapPage.refresh(data);
    }
}

