/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor;

import aurora.ide.editor.BaseCompositeMapEditor;
import aurora.ide.editor.CompositeMapPage;
import aurora.ide.editor.CompositeMapTreePage;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.DialogUtil;
import java.io.ByteArrayInputStream;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import uncertain.composite.CompositeMap;

public abstract class CompositeMapTreeEditor
extends BaseCompositeMapEditor {
    protected CompositeMapTreePage treePage;

    public CompositeMapPage initMainViewerPage() {
        this.treePage = this.initTreePage();
        return this.treePage;
    }

    public abstract CompositeMapTreePage initTreePage();

    protected void pageChange(int newPageIndex) {
        int currentPage = this.getCurrentPage();
        super.pageChange(newPageIndex);
        if (!this.mainViewerPage.isFormContendCreated()) {
            return;
        }
        if (currentPage == this.mainViewerIndex && newPageIndex == this.textPageIndex) {
            this.locateTextPage();
        } else if (currentPage == this.textPageIndex && newPageIndex == this.mainViewerIndex && this.getTextPage().checkContentFormat()) {
            this.locateTreePage();
        }
    }

    private void locateTreePage() {
        CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
        try {
            ByteArrayInputStream content = new ByteArrayInputStream(this.getTextPage().getContent().getBytes("UTF-8"));
            CompositeMap cm = parser.getCompositeMapFromLine(content, this.getTextPage().getCursorLine());
            if (cm != null) {
                this.treePage.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)cm), true);
            }
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    private void locateTextPage() {
        CompositeMap selection = this.treePage.getSelection();
        if (selection == null) {
            return;
        }
        CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
        int line = 0;
        try {
            ByteArrayInputStream content = new ByteArrayInputStream(this.getTextPage().getContent().getBytes("UTF-8"));
            line = parser.LocateCompositeMapLine(content, selection);
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        int offset = this.getTextPage().getOffsetFromLine(line);
        int length = this.getTextPage().getLengthOfLine(line);
        if (offset == 0 || length == 0) {
            return;
        }
        this.getTextPage().resetHighlightRange();
        this.getTextPage().setHighlightRange(offset, length, true);
    }
}

