/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor;

import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.editor.FixedSizeControlListener;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.JavaScriptConfiguration;
import aurora.ide.editor.widgets.CompositeMapTreeViewer;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.PropertyHashViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uncertain.composite.CompositeMap;
import uncertain.schema.Element;
import uncertain.schema.IType;

public class BaseCompositeMapViewer
implements IViewer {
    private CompositeMapTreeViewer treeViewer;
    private PropertySection propertySection;
    private CompositeMap data;
    IViewer viewer;
    SashForm control;

    public BaseCompositeMapViewer(IViewer viewer, CompositeMap data) {
        this.viewer = viewer;
        this.data = data;
    }

    public void createFormContent(Composite parent) throws ApplicationException {
        parent.setLayout((Layout)new FillLayout());
        this.control = new SashForm(parent, 0);
        this.createElementContent((Composite)this.control);
        this.createPropertyContent((Composite)this.control);
        this.treeViewer.addSelectionChangedListener(new ElementSelectionListener());
        this.control.addControlListener((ControlListener)new FixedSizeControlListener(500));
    }

    private void createElementContent(Composite mContent) {
        this.treeViewer = new CompositeMapTreeViewer(this, this.data);
        this.treeViewer.create(mContent);
    }

    protected void createPropertyContent(Composite mContent) throws ApplicationException {
        this.propertySection = new PropertySection(this);
        this.propertySection.create(mContent);
    }

    public void refresh(CompositeMap data) {
        this.data = data;
        this.treeViewer.setInput(data);
    }

    public CompositeMap getData() {
        return this.data;
    }

    public void setData(CompositeMap data) {
        this.data = data;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer.getTreeViewer();
    }

    public CompositeMap getSelection() {
        TreeSelection selection = (TreeSelection)this.treeViewer.getTreeViewer().getSelection();
        Object selected = selection.getFirstElement();
        if (selected == null) {
            return null;
        }
        CompositeMap data = (CompositeMap)selected;
        return data;
    }

    public CompositeMap getContent() {
        return this.data;
    }

    public Control getControl() {
        return this.control;
    }

    public String getFullContent() {
        String encoding = "UTF-8";
        String xml_decl = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n";
        return String.valueOf(xml_decl) + CommentXMLOutputter.defaultInstance().toXML(this.data, true);
    }

    public void setContent(CompositeMap content) {
        this.data = content;
        this.treeViewer.setInput(this.data);
    }

    public void refresh(boolean isDirty) {
        if (isDirty) {
            this.viewer.refresh(isDirty);
        } else {
            this.treeViewer.refresh();
            this.propertySection.refresh(false);
        }
    }

    class ElementSelectionListener
    implements ISelectionChangedListener {
        private boolean validError = false;

        ElementSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.validError) {
                this.validError = false;
                return;
            }
            TreeSelection selection = (TreeSelection)event.getSelection();
            CompositeMap data = (CompositeMap)selection.getFirstElement();
            boolean validation = this.getValidation(BaseCompositeMapViewer.this.treeViewer.getFocus(), data);
            String errorMessage = BaseCompositeMapViewer.this.propertySection.clear(validation);
            if (errorMessage != null) {
                this.validError = true;
                DialogUtil.showErrorMessageBox(errorMessage);
                BaseCompositeMapViewer.this.treeViewer.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)BaseCompositeMapViewer.this.treeViewer.getFocus()));
                return;
            }
            if (data == null) {
                return;
            }
            BaseCompositeMapViewer.this.treeViewer.setFocus(data);
            try {
                BaseCompositeMapViewer.this.propertySection.setInput(data);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        }

        private boolean getValidation(CompositeMap focus, CompositeMap selection) {
            if (focus == null || selection == null) {
                return true;
            }
            return !this.isArryRelation(focus, selection) && !this.isArryRelation(selection, focus);
        }

        private boolean isArryRelation(CompositeMap parent, CompositeMap child) {
            Element parent_element = CompositeMapUtil.getElement(parent);
            if (parent_element == null || !parent_element.isArray()) {
                return false;
            }
            Element child_element = CompositeMapUtil.getElement(child);
            if (child_element == null) {
                return false;
            }
            IType parentIType = parent_element.getElementType();
            return child_element.getQName().equals((Object)parentIType.getQName()) || child_element.isExtensionOf(parentIType);
        }
    }

    class PropertySection
    implements IViewer {
        private CTabFolder mTabFolder;
        private PropertyHashViewer mPropertyEditor;
        private GridViewer gridViewer;
        private SourceViewer textSection;
        IViewer viewer;

        PropertySection(IViewer viewer) {
            this.viewer = viewer;
        }

        public void create(Composite parent) throws ApplicationException {
            this.createTabFolder(parent);
            this.createPropertyHashTab((Composite)this.mTabFolder);
            this.createPropertyGridTab((Composite)this.mTabFolder);
            this.createTextTab((Composite)this.mTabFolder);
        }

        private void createPropertyHashTab(Composite parent) {
            this.mPropertyEditor = new PropertyHashViewer(this.viewer, parent);
            this.mPropertyEditor.createEditor();
            this.mTabFolder.getItem(0).setControl(this.mPropertyEditor.getControl());
        }

        private void createPropertyGridTab(Composite parent) throws ApplicationException {
            this.gridViewer = new GridViewer(null, 8);
            this.gridViewer.setParent(this);
            this.gridViewer.createViewer(parent);
            this.mTabFolder.getItem(1).setControl(this.gridViewer.getControl());
        }

        private void createTextTab(Composite parent) {
            this.textSection = new SourceViewer(parent, null, 770);
            this.textSection.configure((SourceViewerConfiguration)new JavaScriptConfiguration(new ColorManager()));
            String fn = "Consolas";
            if (SWT.getPlatform().equalsIgnoreCase("win32")) {
                fn = "Courier New";
            }
            this.textSection.getTextWidget().setFont(new Font(null, fn, 10, 0));
            Document document = new Document();
            this.textSection.setDocument((IDocument)document);
            this.textSection.getTextWidget().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    String newText = PropertySection.this.textSection.getDocument().get();
                    if (newText == null) {
                        newText = "";
                    }
                    newText = newText.trim();
                    String oldText = BaseCompositeMapViewer.this.treeViewer.getFocus().getText();
                    if (oldText == null) {
                        oldText = "";
                    }
                    if (!newText.equals(oldText = oldText.trim())) {
                        BaseCompositeMapViewer.this.treeViewer.getFocus().setText(newText);
                        PropertySection.this.refresh(true);
                    }
                }
            });
            this.mTabFolder.getItem(2).setControl(this.textSection.getControl());
        }

        public void setInput(CompositeMap data) throws ApplicationException {
            Element em = CompositeMapUtil.getElement(data);
            if (em != null && em.isArray()) {
                this.gridViewer.createViewer((Composite)this.mTabFolder, data);
                this.mTabFolder.getItem(1).setControl(this.gridViewer.getControl());
                this.mTabFolder.setSelection(1);
                this.mTabFolder.layout(true);
            } else {
                this.mPropertyEditor.setData(data);
                this.mTabFolder.setSelection(0);
                this.mTabFolder.layout(true);
            }
            String a = data.getText();
            if (a != null && !a.trim().equals("")) {
                this.textSection.getTextWidget().setText(data.getText());
                this.mTabFolder.setSelection(2);
                this.mTabFolder.layout(true);
            } else {
                this.textSection.getTextWidget().setText("");
            }
        }

        public String clear(boolean validation) {
            String errorMessage = this.mPropertyEditor.clear(validation);
            if (errorMessage != null) {
                return errorMessage;
            }
            errorMessage = this.gridViewer.clearAll(validation);
            if (errorMessage != null) {
                return errorMessage;
            }
            return null;
        }

        public void refresh(boolean isDirty) {
            if (isDirty) {
                this.viewer.refresh(isDirty);
            } else {
                this.mPropertyEditor.refresh();
                this.gridViewer.refresh(false);
            }
        }

        private void createTabFolder(final Composite parent) {
            this.mTabFolder = new CTabFolder(parent, 128);
            this.mTabFolder.setMaximizeVisible(true);
            this.mTabFolder.setBorderVisible(true);
            this.mTabFolder.setSimple(false);
            this.mTabFolder.setTabHeight(23);
            CTabItem tabItem1 = new CTabItem(this.mTabFolder, 514);
            String tab = "         ";
            tabItem1.setText(String.valueOf(tab) + LocaleMessage.getString("property.name") + tab);
            CTabItem tabItem2 = new CTabItem(this.mTabFolder, 514);
            tabItem2.setText(String.valueOf(tab) + LocaleMessage.getString("child.list") + tab);
            CTabItem tabItem3 = new CTabItem(this.mTabFolder, 514);
            tabItem3.setText(String.valueOf(tab) + LocaleMessage.getString("value") + tab);
            if (parent instanceof SashForm) {
                final SashForm sashForm = (SashForm)parent;
                this.mTabFolder.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        if (PropertySection.this.mTabFolder.getMaximized()) {
                            PropertySection.this.mTabFolder.setMaximized(false);
                            sashForm.setMaximizedControl(null);
                            sashForm.layout(true);
                        } else {
                            PropertySection.this.mTabFolder.setMaximized(true);
                            sashForm.setMaximizedControl((Control)PropertySection.this.mTabFolder);
                            sashForm.layout(true);
                        }
                    }
                });
                this.mTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                    public void minimize(CTabFolderEvent event) {
                        PropertySection.this.mTabFolder.setMinimized(true);
                        PropertySection.this.mTabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
                        parent.layout(true);
                    }

                    public void maximize(CTabFolderEvent event) {
                        PropertySection.this.mTabFolder.setMaximized(true);
                        sashForm.setMaximizedControl((Control)PropertySection.this.mTabFolder);
                        parent.layout(true);
                    }

                    public void restore(CTabFolderEvent event) {
                        PropertySection.this.mTabFolder.setMaximized(false);
                        sashForm.setMaximizedControl(null);
                        parent.layout(true);
                    }
                });
            }
        }
    }
}

