/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor;

import aurora.ide.AuroraPlugin;
import aurora.ide.AuroraProjectNature;
import aurora.ide.editor.CompositeMapPage;
import aurora.ide.editor.InputFileListener;
import aurora.ide.editor.outline.BaseOutlinePage;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import uncertain.composite.CompositeMap;

public abstract class BaseCompositeMapEditor
extends FormEditor {
    protected CompositeMapPage mainViewerPage;
    private TextPage textPage = new TextPage(this);
    private boolean dirty = false;
    private File file;
    protected int mainViewerIndex;
    protected int textPageIndex;
    private BaseOutlinePage outline = new BaseOutlinePage();

    public BaseCompositeMapEditor() {
        this.mainViewerPage = this.initMainViewerPage();
    }

    public abstract CompositeMapPage initMainViewerPage();

    protected void addPages() {
        try {
            this.mainViewerIndex = this.addPage((IFormPage)this.mainViewerPage);
            this.textPageIndex = this.addPage((IEditorPart)this.getTextPage(), this.getEditorInput());
            this.setPageText(this.textPageIndex, TextPage.textPageTitle);
        }
        catch (PartInitException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput of FileStoreEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        AuroraPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new InputFileListener((EditorPart)this));
        if (input instanceof IFileEditorInput) {
            IFile ifile = ((IFileEditorInput)input).getFile();
            this.file = new File(AuroraResourceUtil.getIfileLocalPath(ifile));
        }
        if (input instanceof FileStoreEditorInput) {
            try {
                this.file = new File(((FileStoreEditorInput)input).getURI().toURL().getFile());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        String fileName = this.file.getName();
        this.setPartName(fileName);
    }

    private void autoAddAuroraNatue(IFile file) {
        if (file.getName().toLowerCase().endsWith(".bm") || file.getName().toLowerCase().endsWith(".screen")) {
            IProject project = file.getProject();
            try {
                if (!AuroraProjectNature.hasAuroraNature(project)) {
                    AuroraProjectNature.addAuroraNature(project);
                }
            }
            catch (CoreException e) {
                DialogUtil.logErrorException(e);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        int currentPage = this.getCurrentPage();
        if (currentPage == this.textPageIndex) {
            try {
                this.getTextPage().doSave(monitor);
            }
            catch (Throwable e) {
                DialogUtil.showExceptionMessageBox(e);
                return;
            }
        } else if (currentPage == this.mainViewerIndex) {
            this.getTextPage().setSyc(true);
            this.mainViewerPage.doSave(monitor);
        }
        this.setDirty(false);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        super.editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public File getFile() {
        return this.file;
    }

    public void editorDirtyStateChanged() {
        if (!this.dirty) {
            this.setDirty(true);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == this.mainViewerIndex) {
            try {
                this.sycMainViewerPageWithTextPage();
            }
            catch (Exception e) {
                this.getTextPage().setIgnorceSycOnce(true);
                this.setActivePage(this.textPageIndex);
                String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                DialogUtil.showErrorMessageBox(errorMessage);
                return;
            }
        } else if (newPageIndex == this.textPageIndex) {
            if (this.getTextPage().isIgnorceSycOnce()) {
                this.getTextPage().setIgnorceSycOnce(false);
                return;
            }
            this.sycTextPageWithMainViewerPage();
        }
        this.outline.setActiveEditor(this.getEditor(newPageIndex));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            return this.outline;
        }
        return super.getAdapter(adapter);
    }

    private boolean sycMainViewerPageWithTextPage() throws ApplicationException {
        CompositeMap data = this.getTextPage().toCompoisteMap();
        if (this.mainViewerPage.getData() == null) {
            this.mainViewerPage.setData(data);
        } else if (this.getTextPage().isModify() && this.mainViewerPage != null) {
            this.mainViewerPage.refreshFormContent(data);
        }
        this.getTextPage().setModify(false);
        return true;
    }

    private boolean sycTextPageWithMainViewerPage() {
        if (this.mainViewerPage.isModify()) {
            this.mainViewerPage.setModify(false);
            this.getTextPage().refresh(CompositeMapUtil.getFullContent(this.mainViewerPage.getData()));
            return true;
        }
        return true;
    }

    public TextPage getTextPage() {
        return this.textPage;
    }
}

