/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.editor.core.IViewer;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import uncertain.composite.CompositeMap;
import uncertain.schema.Element;

public abstract class AbstractCMViewer
implements IViewer {
    protected CompositeMap selectedData;
    protected CompositeMap focusData;

    public void copyElement() {
        CommentCompositeMap child = new CommentCompositeMap(this.getFocus());
        child.setParent(this.getFocus().getParent());
        this.setSelection(child);
    }

    public void pasteElement() {
        CompositeMap selectedCm = this.getSelection();
        if (selectedCm == null) {
            return;
        }
        CompositeMap parentComp = this.getFocus();
        if (!CompositeMapUtil.validNextNodeLegalWithAction(parentComp, selectedCm)) {
            return;
        }
        CommentCompositeMap child = new CommentCompositeMap(selectedCm);
        if (child != null) {
            parentComp.addChild((CompositeMap)child);
            selectedCm.getParent().removeChild(selectedCm);
            CompositeMapUtil.addArrayNode(parentComp);
        }
        selectedCm = null;
        this.refresh(true);
    }

    public void cutElement() {
        this.setSelection(this.getFocus());
    }

    public void removeElement() {
        Element em;
        CompositeMap comp = this.getFocus();
        if (comp != null && (em = CompositeMapUtil.getElement(comp)) != null && em.isArray()) {
            if (comp.getChildsNotNull().size() > 0) {
                int buttonID = DialogUtil.showConfirmDialogBox(LocaleMessage.getString("clear.array.question"));
                switch (buttonID) {
                    case 32: {
                        if (comp != null) {
                            comp.getChildsNotNull().clear();
                            this.refresh(true);
                            return;
                        }
                        this.refresh(true);
                    }
                    case 256: {
                        return;
                    }
                }
            }
            DialogUtil.showWarningMessageBox(LocaleMessage.getString("can.not.delete.array.hint"));
            return;
        }
        int buttonID = DialogUtil.showConfirmDialogBox(LocaleMessage.getString("delete.element.confirm"));
        switch (buttonID) {
            case 32: {
                if (comp != null) {
                    CompositeMap parentCM = comp.getParent();
                    Element element = CompositeMapUtil.getElement(parentCM);
                    if (element != null && element.isArray()) {
                        comp.getParent().removeChild(comp);
                        if (parentCM.getChilds() == null || parentCM.getChilds().size() == 0) {
                            parentCM.getParent().removeChild(parentCM);
                        }
                    } else {
                        parentCM.removeChild(comp);
                    }
                }
                this.refresh(true);
            }
        }
    }

    public CompositeMap getSelection() {
        return this.selectedData;
    }

    public void setSelection(CompositeMap data) {
        this.selectedData = data;
    }

    public void setFocus(CompositeMap data) {
        this.focusData = data;
    }

    public CompositeMap getFocus() {
        return this.focusData;
    }

    public abstract CompositeMap getInput();
}

