/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.dialog;

import aurora.ide.AuroraPlugin;
import aurora.ide.dialog.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ParamQueryDialog
extends Dialog {
    private final int MAX_PARAMETERS = 5;
    private IDialogSettings settings = AuroraPlugin.getDefault().getDialogSettingsSection("queryParam");
    private List<Parameter> repeatParameter = new ArrayList<Parameter>(10);
    private List<Parameter> unRepeatParameter = new ArrayList<Parameter>(5);
    private List<Parameter> parameter;
    private ComboBoxCellEditor cboCellEditor;
    private TableViewer tableViewer;
    private boolean repeat;

    public ParamQueryDialog(Shell parent, String sql) {
        super(parent);
        this.initDialog(sql);
    }

    private void initDialog(String sql) {
        String[] ps = sql.split("\\$");
        LinkedHashSet<String> unRepeat = new LinkedHashSet<String>();
        int i = 1;
        while (i < ps.length) {
            Parameter p = new Parameter();
            p.setIndex(i);
            p.setName(ps[i].replaceAll("(.*\\{)|(\\}.*)", ""));
            unRepeat.add(p.getName());
            this.repeatParameter.add(p);
            ++i;
        }
        int index = 1;
        for (String s : unRepeat) {
            Parameter p = new Parameter();
            p.setIndex(index);
            p.setName(s);
            this.unRepeatParameter.add(p);
            ++index;
        }
        this.parameter = this.unRepeatParameter;
        this.repeat = false;
    }

    public String[] getValues() {
        String[] values = new String[this.repeatParameter.size()];
        if (this.repeat) {
            int i = 0;
            while (i < this.repeatParameter.size()) {
                values[i] = this.repeatParameter.get(i).getName().indexOf(":") != -1 ? "~" + this.repeatParameter.get(i).getValue() : this.repeatParameter.get(i).getValue();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.repeatParameter.size()) {
                Parameter p = this.repeatParameter.get(i);
                for (Parameter pp : this.unRepeatParameter) {
                    if (!pp.getName().equals(p.getName())) continue;
                    if (pp.getName().indexOf(":") != -1) {
                        values[i] = "~" + pp.getValue();
                        break;
                    }
                    values[i] = pp.getValue();
                    break;
                }
                ++i;
            }
        }
        return values;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x400 | 0x1000051;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        ++layout.numColumns;
        final Button button = new Button(composite, 32);
        button.setText("\u5141\u8bb8\u91cd\u590d\u53c2\u6570\u540d");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    ParamQueryDialog.this.parameter = ParamQueryDialog.this.repeatParameter;
                    ParamQueryDialog.this.repeat = true;
                } else {
                    ParamQueryDialog.this.parameter = ParamQueryDialog.this.unRepeatParameter;
                    ParamQueryDialog.this.repeat = false;
                }
                ParamQueryDialog.this.tableViewer.setInput((Object)ParamQueryDialog.this.parameter);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.getShell().setText("\u53d8\u91cf");
        TableColumnLayout tclayout = new TableColumnLayout();
        container.setLayout((Layout)tclayout);
        this.tableViewer = new TableViewer(container, 68352);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setEnabled(true);
        TableColumn colIndex = new TableColumn(table, 0);
        colIndex.setText("");
        tclayout.setColumnData((Widget)colIndex, (ColumnLayoutData)new ColumnWeightData(25, 25, false));
        colIndex.setResizable(false);
        TableColumn colName = new TableColumn(table, 0);
        colName.setText("\u53c2\u6570\u540d");
        colName.pack();
        tclayout.setColumnData((Widget)colName, (ColumnLayoutData)new ColumnWeightData(100, 100, false));
        TableColumn colValue = new TableColumn(table, 0);
        colValue.setText("\u53c2\u6570\u503c");
        tclayout.setColumnData((Widget)colValue, (ColumnLayoutData)new ColumnWeightData(235, 100, true));
        this.tableViewer.setColumnProperties(new String[]{"", "Name", "Value"});
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput(this.parameter);
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tColumn = tableColumnArray[n2];
            if (!tColumn.getText().equals("\u53c2\u6570\u503c")) {
                tColumn.pack();
            }
            ++n2;
        }
        this.cboCellEditor = new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), new String[0]);
        CellEditor[] cellEditors = new CellEditor[]{null, null, this.cboCellEditor};
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        return container;
    }

    private String[] getOldParameters(String name) {
        return this.settings.getArray(name) == null ? new String[]{} : this.settings.getArray(name);
    }

    private void setParameter(String name, String parameter) {
        String[] oldParameters = this.getOldParameters(name);
        if (oldParameters.length >= 1 && oldParameters[0].equals(parameter)) {
            return;
        }
        String[] temp = oldParameters.length >= 5 ? new String[5] : (oldParameters.length < 1 ? new String[1] : new String[oldParameters.length + 1]);
        temp[0] = parameter;
        int i = 1;
        while (i < temp.length && oldParameters.length >= 1) {
            temp[i] = oldParameters[i - 1];
            ++i;
        }
        this.settings.put(name, temp);
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            Parameter p = (Parameter)element;
            if (property.equals("Value")) {
                ParamQueryDialog.this.cboCellEditor.setItems(ParamQueryDialog.this.getOldParameters(p.getName()));
                return -1;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            Parameter p = (Parameter)item.getData();
            if (property.equals("Value")) {
                int index = (Integer)value;
                String sValue = "";
                if (index != -1) {
                    sValue = ParamQueryDialog.this.cboCellEditor.getItems()[index];
                } else {
                    CCombo combo = (CCombo)ParamQueryDialog.this.cboCellEditor.getControl();
                    sValue = combo.getText();
                }
                if (!sValue.trim().equals("")) {
                    ParamQueryDialog.this.setParameter(p.getName(), sValue);
                }
                p.setValue(sValue);
            }
            ParamQueryDialog.this.tableViewer.update((Object)p, null);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Parameter) {
                Parameter p = (Parameter)element;
                if (columnIndex == 0) {
                    return Integer.toString(p.getIndex());
                }
                if (columnIndex == 1) {
                    return p.getName();
                }
                if (columnIndex == 2) {
                    return p.getValue();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

