/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.dialog;

import aurora.ide.helpers.DialogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddTagDialog
extends Dialog {
    private Combo cboNamespace;
    private Text txtTag;
    private String namespace;
    private String selectNamespace;
    private Set<String> tags = new TreeSet<String>();
    private String[] namespaces;
    private Map<String, List<String>> customMap;
    private Map<String, List<String>> baseMap;
    private StringBuffer sb = new StringBuffer();

    public AddTagDialog(Shell parentShell, String[] namespaces, Map<String, List<String>> baseMap, String selectNamespace) {
        super(parentShell);
        this.namespaces = namespaces;
        this.baseMap = baseMap;
        this.selectNamespace = selectNamespace;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x400 | 0x1000051;
    }

    protected Point getInitialSize() {
        return new Point(500, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.getShell().setText("Add Tags");
        GridLayout layou = new GridLayout();
        layou.numColumns = 2;
        container.setLayout((Layout)layou);
        Label lblNamespace = new Label(container, 0);
        lblNamespace.setText("Namespace:");
        GridData gdNamespace = new GridData(768);
        this.cboNamespace = new Combo(container, 4);
        this.cboNamespace.setLayoutData((Object)gdNamespace);
        int i = 0;
        while (i < this.namespaces.length) {
            this.cboNamespace.add(this.namespaces[i]);
            if (this.namespaces[i].equals(this.selectNamespace)) {
                this.cboNamespace.select(i);
            }
            ++i;
        }
        GridData gdlblTag = new GridData();
        gdlblTag.verticalAlignment = 128;
        Label lblTag = new Label(container, 0);
        lblTag.setLayoutData((Object)gdlblTag);
        lblTag.setText("Tag:");
        GridData gdTag = new GridData(1808);
        this.txtTag = new Text(container, 2562);
        this.txtTag.setLayoutData((Object)gdTag);
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void okPressed() {
        this.namespace = this.cboNamespace.getText().trim();
        String[] stringArray = this.txtTag.getText().split("\r\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.tags.add(s.trim());
            ++n2;
        }
        if ("".equals(this.namespace.trim())) {
            DialogUtil.showWarningMessageBox("\u8bf7\u8f93\u5165\u547d\u540d\u7a7a\u95f4\u3002");
            return;
        }
        if ("".equals(this.txtTag.getText().trim())) {
            DialogUtil.showWarningMessageBox("\u8bf7\u8f93\u5165\u6807\u7b7e\uff0c\u4ee5\u6362\u884c\u7b26\u5206\u5272\u3002");
            return;
        }
        this.fillMap();
        super.okPressed();
    }

    private void fillMap() {
        this.customMap = new TreeMap<String, List<String>>();
        this.customMap.put(this.namespace, new ArrayList());
        this.sb.append("*" + this.namespace);
        for (String s : this.tags) {
            if ("".equals(s) || this.baseMap.containsKey(this.namespace) && this.baseMap.get(this.namespace).contains(s)) continue;
            this.customMap.get(this.namespace).add(s);
            this.sb.append("!" + s);
        }
        this.sb.append("!");
    }

    public String getStoreValue() {
        return this.sb.toString();
    }

    public Map<String, List<String>> getCustomMap() {
        return this.customMap;
    }
}

