/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LocaleMessage;
import java.util.HashSet;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

class ManualDataSetPage
extends WizardPage {
    public static final String PAGE_NAME = "ManualDataSet";
    private String id;
    CompositeMap parentCM;

    protected ManualDataSetPage(CompositeMap parentCM) {
        super(PAGE_NAME);
        this.setTitle(LocaleMessage.getString("manual.create.dataset.page"));
        this.parentCM = parentCM;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(content, 256);
        label.setText(LocaleMessage.getString("please.input.id"));
        final Text text = new Text(content, 0);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (text.getText() != null && !text.getText().equals("")) {
                    HashSet ids = new HashSet();
                    CompositeMapUtil.collectAttribueValues(ids, "id", ManualDataSetPage.this.parentCM.getRoot());
                    if (ids.contains(text.getText())) {
                        ManualDataSetPage.this.setErrorMessage(LocaleMessage.getString("This.id.has.exists.please.change.it"));
                        ManualDataSetPage.this.setPageComplete(false);
                        return;
                    }
                    ManualDataSetPage.this.setErrorMessage(null);
                    ManualDataSetPage.this.id = text.getText();
                    ManualDataSetPage.this.setPageComplete(true);
                } else {
                    ManualDataSetPage.this.setErrorMessage(LocaleMessage.getString("id.can.not.be.null"));
                    ManualDataSetPage.this.setPageComplete(false);
                }
            }
        });
        this.setControl((Control)content);
    }

    public String getId() {
        return this.id;
    }
}

