/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import uncertain.composite.CompositeMap;

class BMSelectionPage
extends WizardPage {
    public static final String PAGE_NAME = "CreateDataSetFromBMPage";
    private Text bmselectionsText;
    private String bmselections;
    private Button justForInput;
    private Button fromServer;
    private Button canSave;

    protected BMSelectionPage() {
        super(PAGE_NAME);
        this.setTitle(LocaleMessage.getString("create.from.bm.file.page"));
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(768);
        Group bmilesGroup = new Group(content, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        bmilesGroup.setLayout((Layout)layout);
        bmilesGroup.setLayoutData((Object)new GridData(768));
        bmilesGroup.setText(LocaleMessage.getString("business.model.files"));
        this.bmselectionsText = new Text((Composite)bmilesGroup, 0);
        this.bmselectionsText.setLayoutData((Object)new GridData(768));
        this.bmselectionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BMSelectionPage.this.bmselectionsText.getText() != null && !BMSelectionPage.this.bmselectionsText.getText().equals("")) {
                    BMSelectionPage.this.bmselections = BMSelectionPage.this.bmselectionsText.getText();
                    BMSelectionPage.this.setErrorMessage(null);
                    BMSelectionPage.this.setPageComplete(true);
                } else {
                    BMSelectionPage.this.setErrorMessage(LocaleMessage.getString("bm.file.selection.can.not.be.null"));
                    BMSelectionPage.this.setPageComplete(false);
                }
            }
        });
        if (this.bmselections != null) {
            this.bmselectionsText.setText(this.bmselections);
        }
        Button uncertainProDirButton = new Button((Composite)bmilesGroup, 8);
        uncertainProDirButton.setData((Object)data);
        uncertainProDirButton.setText(LocaleMessage.getString("openBrowse"));
        uncertainProDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    BMSelectionPage.this.fireEvent();
                }
                catch (Exception e) {
                    DialogUtil.showExceptionMessageBox(e);
                }
            }
        });
        this.justForInput = new Button(content, 32);
        this.justForInput.setText(LocaleMessage.getString("is.just.for.input"));
        final Group configGroup = new Group(content, 0);
        configGroup.setText(LocaleMessage.getString("config.query.and.save"));
        layout = new GridLayout();
        configGroup.setLayout((Layout)layout);
        data = new GridData(768);
        configGroup.setLayoutData((Object)data);
        Group dataQueryGroup = new Group((Composite)configGroup, 0);
        dataQueryGroup.setText(LocaleMessage.getString("fill.data"));
        data = new GridData(768);
        dataQueryGroup.setLayoutData((Object)data);
        dataQueryGroup.setLayout((Layout)layout);
        this.fromServer = new Button((Composite)dataQueryGroup, 16);
        this.fromServer.setText(LocaleMessage.getString("get.data.from.server"));
        this.fromServer.setSelection(true);
        final Button fromClient = new Button((Composite)dataQueryGroup, 16);
        fromClient.setText(LocaleMessage.getString("get.data.from.ajax"));
        this.canSave = new Button((Composite)configGroup, 32);
        this.canSave.setText(LocaleMessage.getString("can.save"));
        this.canSave.setSelection(true);
        this.justForInput.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BMSelectionPage.this.justForInput.getSelection()) {
                    configGroup.setEnabled(false);
                    BMSelectionPage.this.fromServer.setSelection(false);
                    fromClient.setSelection(false);
                    BMSelectionPage.this.canSave.setSelection(false);
                } else {
                    configGroup.setEnabled(true);
                    BMSelectionPage.this.fromServer.setSelection(true);
                    fromClient.setSelection(false);
                    BMSelectionPage.this.canSave.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setControl((Control)content);
    }

    public boolean getJustForInput() {
        return this.justForInput.getSelection();
    }

    public boolean getFromServer() {
        return this.fromServer.getSelection();
    }

    public boolean getCanSave() {
        return this.canSave.getSelection();
    }

    public String getSelection() {
        return this.bmselections;
    }

    public void setSelection(String bmselections) {
        this.bmselections = bmselections;
    }

    private void fireEvent() throws ApplicationException {
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IFile ifile = ((IFileEditorInput)input).getFile();
        IProject project = ifile.getProject();
        String bmFilesDir = ProjectUtil.getBMHomeLocalPath(project);
        File baseDir = new File(bmFilesDir);
        String fullPath = baseDir.getAbsolutePath();
        CompositeMap bmFiles = this.getAllBMFiles(baseDir, fullPath);
        String[] columnProperties = new String[]{"name", "fullpath"};
        GridViewer gridViewer = new GridViewer(columnProperties, 52);
        gridViewer.setFilterColumn("name");
        gridViewer.setData(bmFiles);
        GridDialog dialog = new GridDialog(new Shell(), gridViewer);
        if (dialog.open() == 0 && dialog.getSelected() != null) {
            CompositeMap data = dialog.getSelected();
            this.bmselectionsText.setText(data.getString((Object)"fullpath"));
        }
    }

    private CompositeMap getAllBMFiles(File rootFile, String fullPath) {
        CommentCompositeMap bmFiles = new CommentCompositeMap();
        this.getChilds(rootFile, bmFiles, fullPath);
        return bmFiles;
    }

    private void getChilds(File file, CompositeMap parent, String fullPath) {
        if (file.isDirectory()) {
            File[] nextLevel = file.listFiles();
            int i = 0;
            while (i < nextLevel.length) {
                this.getChilds(nextLevel[i], parent, fullPath);
                ++i;
            }
        } else if (file.getName().toLowerCase().endsWith(".bm")) {
            CommentCompositeMap child = new CommentCompositeMap();
            String fullpath = this.getClassName(file, fullPath);
            child.put("name", file.getName());
            child.put("fullpath", fullpath);
            parent.addChild((CompositeMap)child);
        }
    }

    private String getClassName(File file, String fullpath) {
        String path = file.getPath();
        int end = path.lastIndexOf(".");
        path = path.substring(fullpath.length() + 1, end);
        path = path.replace(File.separatorChar, '.');
        return path;
    }
}

