/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.component.wizard.IWizardAction;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.ActionInfo;
import aurora.ide.node.action.ActionListener;
import aurora.ide.node.action.AddElementAction;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Element;
import uncertain.schema.Wizard;

public class ActionsFactory {
    private static ActionsFactory instance;

    public static synchronized ActionsFactory getInstance() {
        if (instance == null) {
            instance = new ActionsFactory();
        }
        return instance;
    }

    public ActionListener[] createActions(ActionInfo actionInfo) throws ApplicationException {
        CompositeMap currentNode = actionInfo.getCurrentNode();
        Element element = CompositeMapUtil.getElement(currentNode);
        if (element == null) {
            DialogUtil.showWarningMessageBox(LocaleMessage.getString("undefined.self.element"));
            return null;
        }
        ActionListener[] wizardActionListeners = this.getWizardActions(actionInfo, element);
        List childElements = CompositeMapUtil.getAvailableChildElements(currentNode);
        ActionListener[] childActionListeners = null;
        if (childElements != null) {
            childActionListeners = new ActionListener[childElements.size()];
            Iterator ite = childElements.iterator();
            int i = 0;
            while (ite.hasNext()) {
                Object object = ite.next();
                if (object instanceof Element) {
                    Element ele = (Element)object;
                    QualifiedName qName = ele.getQName();
                    childActionListeners[i] = new AddElementAction(actionInfo.getViewer(), currentNode, qName, 6);
                }
                ++i;
            }
        }
        return this.collectActionListeners(wizardActionListeners, childActionListeners);
    }

    private ActionListener[] getWizardActions(ActionInfo actionProperties, Element element) throws ApplicationException {
        Object wizardObject;
        Class<?> cls;
        QualifiedName wizardQualifiedName = element.getWizardQName();
        Wizard wizard = LoadSchemaManager.getSchemaManager().getWizard(wizardQualifiedName);
        if (wizard == null) {
            return null;
        }
        String cls_name = wizard.getInstanceClass();
        try {
            cls = Class.forName(cls_name);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationException("\u627e\u4e0d\u5230\u7c7b,\u8bf7\u68c0\u67e5\u7c7b\u540d:", e);
        }
        try {
            wizardObject = cls.newInstance();
        }
        catch (Exception e) {
            throw new ApplicationException("\u5b9e\u4f8b\u5316\u9519\u8bef:", e);
        }
        IWizardAction wizardAction = (IWizardAction)wizardObject;
        ActionListener[] wizardActionListeners = wizardAction.createActions(actionProperties);
        return wizardActionListeners;
    }

    private ActionListener[] collectActionListeners(ActionListener[] wizardActionListeners, ActionListener[] childActionListeners) {
        int count = 0;
        int wizardCount = 0;
        int childCount = 0;
        if (wizardActionListeners != null && wizardActionListeners.length > 0) {
            wizardCount = wizardActionListeners.length;
        }
        if (childActionListeners != null && childActionListeners.length > 0) {
            childCount = childActionListeners.length;
        }
        count = wizardCount + childCount;
        ActionListener[] totalActionListeners = new ActionListener[count];
        if (wizardCount > 0) {
            System.arraycopy(wizardActionListeners, 0, totalActionListeners, 0, wizardCount);
        }
        if (childCount > 0) {
            System.arraycopy(childActionListeners, 0, totalActionListeners, wizardCount, childCount);
        }
        return totalActionListeners;
    }

    public void addActionsToMenu(Menu menu, ActionInfo actionProperties) throws ApplicationException {
        ActionListener[] actionListeners = this.createActions(actionProperties);
        int i = 0;
        while (i < actionListeners.length) {
            ActionListener action = actionListeners[i];
            MenuItem itemPush = new MenuItem(menu, 8);
            itemPush.addListener(13, (Listener)action);
            itemPush.setText(action.getText());
            itemPush.setImage(action.getDefaultImage());
            ++i;
        }
    }

    public void addActionsToMenuManager(MenuManager menuManager, ActionInfo actionProperties) throws ApplicationException {
        ActionListener[] actionListeners = this.createActions(actionProperties);
        if (actionListeners == null) {
            return;
        }
        int i = 0;
        while (i < actionListeners.length) {
            ActionListener action = actionListeners[i];
            menuManager.add((IAction)action);
            ++i;
        }
    }
}

