/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ProjectUtil;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import uncertain.composite.CompositeMap;

public class ModelReferenceCellEditor
extends StringTextCellEditor {
    public ModelReferenceCellEditor(CellInfo cellProperties) {
        super(cellProperties);
    }

    protected void addCellListener() {
        this.getCellControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    ModelReferenceCellEditor.this.fireEvent();
                }
                catch (Exception e1) {
                    DialogUtil.showExceptionMessageBox(e1);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getCellControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (ModelReferenceCellEditor.this.isTableItemEditor()) {
                    ModelReferenceCellEditor.this.rebuildCellEditor(ModelReferenceCellEditor.this.cellProperties.getTableItem());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void fireEvent() throws ApplicationException {
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IFile ifile = ((IFileEditorInput)input).getFile();
        IProject project = ifile.getProject();
        String bmFilesDir = ProjectUtil.getBMHomeLocalPath(project);
        File baseDir = new File(bmFilesDir);
        String fullPath = baseDir.getAbsolutePath();
        CompositeMap bmFiles = this.getAllBMFiles(baseDir, fullPath);
        String[] columnProperties = new String[]{"name", "fullpath"};
        GridViewer grid = new GridViewer(null, 48);
        grid.setData(bmFiles);
        grid.setFilterColumn("name");
        grid.setColumnNames(columnProperties);
        GridDialog dialog = new GridDialog(new Shell(), grid);
        if (dialog.open() == 0) {
            String value = dialog.getSelected().getString((Object)"fullpath");
            this.setValue(value);
            if (this.isTableItemEditor()) {
                this.cellProperties.getRecord().put((Object)this.cellProperties.getColumnName(), (Object)value);
            } else {
                TableItem item = this.cellProperties.getTableViewer().getViewer().getTable().getSelection()[0];
                CompositeMap data = (CompositeMap)item.getData();
                data.put((Object)this.cellProperties.getColumnName(), (Object)value);
            }
            this.cellProperties.getTableViewer().refresh(true);
        }
    }

    private CompositeMap getAllBMFiles(File rootFile, String fullPath) {
        CommentCompositeMap bmFiles = new CommentCompositeMap();
        this.getChilds(rootFile, bmFiles, fullPath);
        return bmFiles;
    }

    private void getChilds(File file, CompositeMap parent, String fullPath) {
        if (file.isDirectory()) {
            File[] nextLevel = file.listFiles();
            int i = 0;
            while (i < nextLevel.length) {
                this.getChilds(nextLevel[i], parent, fullPath);
                ++i;
            }
        } else if (file.getName().toLowerCase().endsWith(".bm")) {
            CommentCompositeMap child = new CommentCompositeMap();
            String fullpath = this.getClassName(file, fullPath);
            child.put("name", file.getName());
            child.put("fullpath", fullpath);
            parent.addChild((CompositeMap)child);
        }
    }

    private String getClassName(File file, String fullpath) {
        String path = file.getPath();
        int end = path.lastIndexOf(".");
        path = path.substring(fullpath.length() + 1, end);
        path = path.replace(File.separatorChar, '.');
        return path;
    }

    private boolean isTableItemEditor() {
        return this.cellProperties.getTableItem() != null;
    }
}

