/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ICellEditor;
import aurora.ide.helpers.LocaleMessage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ComboxCellEditor
extends ComboBoxCellEditor
implements ICellEditor {
    protected CellInfo cellProperties;

    public ComboxCellEditor(CellInfo cellProperties) {
        this.cellProperties = cellProperties;
    }

    public void createCellEditor(Composite parent) {
        super.setItems(this.cellProperties.getItems());
        super.create(parent);
        super.setValue((Object)new Integer(-1));
    }

    public Control getCellControl() {
        return super.getControl();
    }

    public CellEditor getCellEditor() {
        return this;
    }

    public String getSelection() {
        Object value = this.getValue();
        Integer newInt = (Integer)value;
        if (newInt == -1) {
            return null;
        }
        String dataValue = this.cellProperties.getItems()[newInt];
        return dataValue;
    }

    public void init() {
        Color bg = Display.getDefault().getSystemColor(7);
        if (this.cellProperties.isRequired() && this.getCellControl() != null) {
            this.getCellControl().setBackground(bg);
        }
        Table parent = this.cellProperties.getTable();
        this.createCellEditor((Composite)parent);
        if (this.isTableItemEditor()) {
            this.SetSelection(this.cellProperties.getRecord().getString((Object)this.cellProperties.getColumnName()));
            this.addCellListener();
        }
    }

    public void SetSelection(String value) {
        Integer showValue = (Integer)this.valueToShow(value);
        super.setValue((Object)showValue);
    }

    public boolean validValue(String value) {
        boolean validResult = false;
        String selections = "";
        String errorMessage = "";
        String[] items = this.cellProperties.getItems();
        int i = 0;
        while (i < items.length) {
            String selection = items[i];
            selections = String.valueOf(selections) + selection + ",";
            if (value == null && selection.equals("")) {
                return true;
            }
            if (value != null && value.equals(selection)) {
                return true;
            }
            ++i;
        }
        if (!validResult) {
            errorMessage = "<" + this.cellProperties.getColumnName() + ">" + LocaleMessage.getString("field") + LocaleMessage.getString("value.must.be.in") + "'" + selections + "' !";
            this.setErrorMessage(errorMessage);
            this.getCellControl().setFocus();
            return false;
        }
        return validResult;
    }

    public Object valueToShow(String value) {
        Integer showValue = null;
        String[] items = this.cellProperties.getItems();
        int i = 0;
        while (i < items.length) {
            if (value == null && items[i].equals("")) {
                showValue = new Integer(i);
                break;
            }
            if (items[i].equals(value)) {
                showValue = new Integer(i);
                break;
            }
            ++i;
        }
        if (showValue == null) {
            showValue = new Integer(-1);
        }
        return showValue;
    }

    private void addCellListener() {
        this.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                String dataValue = ComboxCellEditor.this.getSelection();
                ComboxCellEditor.this.cellProperties.getRecord().put((Object)ComboxCellEditor.this.cellProperties.getColumnName(), (Object)dataValue);
                ComboxCellEditor.this.cellProperties.getTableViewer().refresh(true);
            }
        });
        this.getCellControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ComboxCellEditor.this.fillTableCellEditor(ComboxCellEditor.this.cellProperties.getTableViewer().getViewer().getTable(), ComboxCellEditor.this.cellProperties.getTableItem());
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void fillTableCellEditor(Table table, TableItem item) {
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.setEditor(this.getCellControl(), item, 1);
    }

    private boolean isTableItemEditor() {
        return this.cellProperties.getTableItem() != null;
    }
}

