/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.validator;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.processor.AbstractProcessor;
import aurora.ide.builder.validator.AbstractValidator;
import aurora.ide.builder.validator.BmValidator;
import aurora.ide.builder.validator.ScreenValidator;
import aurora.ide.builder.validator.SvcValidator;
import aurora.ide.builder.validator.UncertainLocalValidator;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;

public class IntimeValidator
extends AbstractValidator {
    public IntimeValidator(IFile file) {
        super(file);
    }

    public IntimeValidator(IFile file, IDocument doc) {
        this.file = file;
        this.doc = doc;
        try {
            this.map = CompositeMapUtil.loaderFromString(doc.get());
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        AuroraBuilder.deleteMarkers(file);
    }

    public AbstractProcessor[] getMapProcessor() {
        String ext = this.getFileExt();
        if (this.file.getName().equalsIgnoreCase("uncertain.local.xml")) {
            return new UncertainLocalValidator().getMapProcessor();
        }
        if ("bm".equals(ext)) {
            return new BmValidator().getMapProcessor();
        }
        if ("svc".equals(ext)) {
            return new SvcValidator().getMapProcessor();
        }
        if ("screen".equals(ext)) {
            return new ScreenValidator().getMapProcessor();
        }
        return new AbstractProcessor[0];
    }

    private String getFileExt() {
        String ext = this.file.getFileExtension();
        if (ext == null) {
            return null;
        }
        return ext.toLowerCase();
    }
}

