/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.validator;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import aurora.ide.search.cache.CacheManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;

public abstract class AbstractValidator
implements IterationHandle {
    protected IFile file;
    protected CompositeMap map;
    protected IDocument doc;
    private AbstractProcessor[] aps = null;

    public AbstractValidator(IFile file) {
        this.file = file;
        try {
            this.map = CacheManager.getCompositeMap(file);
            this.doc = CacheManager.getDocument(file);
        }
        catch (Exception e) {
            AuroraBuilder.addMarker(file, e.getMessage(), 1, 2, "aurora.ide.fatalError");
        }
    }

    public AbstractValidator() {
    }

    public final void validate() {
        if (this.map == null) {
            return;
        }
        this.aps = this.getMapProcessor();
        this.map.iterate((IterationHandle)this, true);
        AbstractProcessor[] abstractProcessorArray = this.aps;
        int n = this.aps.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractProcessor np = abstractProcessorArray[n2];
            np.processComplete(this.file, this.map, this.doc);
            ++n2;
        }
    }

    public int process(CompositeMap map) {
        CompositeMapInfo info = new CompositeMapInfo(map, this.doc);
        BuildContext bc = new BuildContext();
        try {
            bc.list = SxsdUtil.getAttributesNotNull(map);
        }
        catch (Exception e) {
            bc.nullListMsg = e.getMessage();
        }
        bc.doc = this.doc;
        bc.file = this.file;
        bc.info = info;
        bc.map = map;
        AbstractProcessor[] abstractProcessorArray = this.aps;
        int n = this.aps.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractProcessor np = abstractProcessorArray[n2];
            np.processMap(bc);
            ++n2;
        }
        return 0;
    }

    public abstract AbstractProcessor[] getMapProcessor();
}

