/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.processor;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;
import uncertain.schema.IType;

public class UrlProcessor
extends AbstractProcessor {
    static final String CONTEXT_PATH = "${/request/@context_path}/";
    static final String AUTOCRUD = "autocrud/";
    static final String MODULES = "modules/";
    static final Pattern dyPattern = Pattern.compile(".*\\$\\{[^}]+\\}.*");
    static final Pattern dynamicPattern = Pattern.compile("\\$\\{[^}]+\\}");

    public void processMap(BuildContext bc) {
        this.processAttribute(bc);
    }

    protected void visitAttribute(Attribute a, BuildContext bc) {
        IType type = a.getAttributeType();
        if (SxsdUtil.isURLReference(type)) {
            String name = a.getName();
            String value = bc.info.getAttrRealValue(name);
            IRegion vregion = bc.info.getAttrValueRegion2(name);
            int line = bc.info.getLineOfRegion(vregion) + 1;
            String uk = bc.map.getString((Object)name);
            if (dynamicPattern.matcher(uk).matches()) {
                return;
            }
            int idx = uk.indexOf(63);
            if (idx != -1) {
                uk = uk.substring(0, idx);
                value = value.substring(0, idx);
            }
            if (uk.startsWith(CONTEXT_PATH)) {
                uk = uk.substring(CONTEXT_PATH.length());
            }
            if (dyPattern.matcher(uk).matches()) {
                return;
            }
            if (uk.endsWith(".screen") || uk.endsWith(".svc")) {
                this.doForScreenOrSvc(uk, name, value, line, vregion, bc);
                return;
            }
            idx = uk.indexOf(AUTOCRUD);
            if (idx != -1) {
                uk = uk.substring(idx + AUTOCRUD.length());
            } else {
                idx = uk.indexOf(MODULES);
                if (idx != -1) {
                    this.doForUnknown(uk, name, value, line, vregion, bc);
                    return;
                }
            }
            uk = uk.split("/")[0];
            this.doForBm(uk, name, value, line, vregion, bc);
        }
    }

    private void doForScreenOrSvc(String uk, String name, String value, int line, IRegion vregion, BuildContext bc) {
        IFile findScreenFile;
        if (BuildContext.LEVEL_UNDEFINED_SCREEN == 0) {
            return;
        }
        if (uk.startsWith("/")) {
            uk = uk.substring(1);
        }
        if ((findScreenFile = ResourceUtil.getFileUnderWebHome(bc.file.getProject(), uk)) != null) {
            return;
        }
        IResource res = bc.file.getParent().findMember(value);
        if (res instanceof IFile) {
            return;
        }
        String msg = String.format(BuildMessages.get("build.notexists"), name, uk);
        int idx = value.indexOf(uk);
        if (idx != -1) {
            vregion = new Region(vregion.getOffset() + idx, uk.length());
        }
        AuroraBuilder.addMarker(bc.file, msg, line, vregion, BuildContext.LEVEL_UNDEFINED_SCREEN, "aurora.ide.undefinedScreen");
    }

    private void doForBm(String uk, String name, String value, int line, IRegion vregion, BuildContext bc) {
        if (BuildContext.LEVEL_UNDEFINED_BM == 0) {
            return;
        }
        IFile bmf = ResourceUtil.getBMFile(bc.file.getProject(), uk);
        if (bmf == null) {
            String msg = null;
            msg = uk.length() == 0 ? String.format(BuildMessages.get("build.notbeempty"), name) : String.format(BuildMessages.get("build.notexists"), name, uk);
            int idx = value.indexOf(uk);
            if (idx != -1) {
                vregion = new Region(vregion.getOffset() + idx, uk.length());
            }
            AuroraBuilder.addMarker(bc.file, msg, line, vregion, BuildContext.LEVEL_UNDEFINED_BM, "aurora.ide.undefinedBM");
        }
    }

    private void doForUnknown(String uk, String name, String value, int line, IRegion vregion, BuildContext bc) {
        String msg = "we currently don`t know what it is , maybe a screen or svc with a wrong file name extension.";
        int idx = value.indexOf(uk);
        if (idx != -1) {
            vregion = new Region(vregion.getOffset() + idx, uk.length());
        }
        AuroraBuilder.addMarker(bc.file, msg, line, vregion, BuildContext.LEVEL_UNDEFINED_SCREEN, "aurora.ide.undefinedScreen");
    }

    public void processComplete(IFile file, CompositeMap map, IDocument doc) {
    }
}

