/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.processor;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class DataSetProcessor
extends AbstractProcessor {
    private Set<String> datasetSet = new HashSet<String>();
    private Set<Object[]> dataSetTask = new HashSet<Object[]>();

    public void processMap(BuildContext bc) {
        if (BuildContext.LEVEL_UNDEFINED_DATASET == 0) {
            return;
        }
        this.processAttribute(bc);
    }

    public void visitAttribute(Attribute a, BuildContext bc) {
        if (SxsdUtil.isDataSetReference(a.getAttributeType())) {
            String name = a.getName();
            String value = bc.map.getString((Object)name);
            if (bc.map.getName().equalsIgnoreCase("dataSet") && name.equalsIgnoreCase("id")) {
                this.datasetSet.add(value);
                return;
            }
            this.dataSetTask.add(new Object[]{name, value, bc});
        }
    }

    public void processComplete(IFile file, CompositeMap map1, IDocument doc) {
        if (BuildContext.LEVEL_UNDEFINED_DATASET == 0) {
            return;
        }
        for (Object[] objs : this.dataSetTask) {
            String name = (String)objs[0];
            String value = (String)objs[1];
            if (this.datasetSet.contains(value)) continue;
            CompositeMapInfo info = ((BuildContext)objs[2]).info;
            IRegion region = info.getAttrValueRegion2(name);
            int line = info.getLineOfRegion(region);
            String msg = String.format(BuildMessages.get("build.dataset.undefined"), name, value);
            IMarker marker = AuroraBuilder.addMarker(file, msg, line + 1, region, BuildContext.LEVEL_UNDEFINED_DATASET, "aurora.ide.undefinedDataSet");
            if (marker == null) continue;
            try {
                marker.setAttribute("ATTRIBUTE_NAME", (Object)name);
                marker.setAttribute("ATTRIBUTE_VALUE", (Object)value);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

