/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.processor;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;
import uncertain.schema.IType;

public class BmProcessor
extends AbstractProcessor {
    private static final Pattern dynamicPattern = Pattern.compile("\\$\\{[^}]+\\}");

    public void processMap(BuildContext bc) {
        if (BuildContext.LEVEL_UNDEFINED_BM == 0) {
            return;
        }
        this.processAttribute(bc);
    }

    protected void visitAttribute(Attribute a, BuildContext bc) {
        IType type = a.getAttributeType();
        if (SxsdUtil.isBMReference(type)) {
            String name = a.getName();
            String bm = bc.map.getString((Object)name);
            if (dynamicPattern.matcher(bm = bm.split("\\?")[0]).matches()) {
                return;
            }
            IFile bmf = ResourceUtil.getBMFile(bc.file.getProject(), bm);
            if (bmf == null) {
                IRegion region = bc.info.getAttrValueRegion2(name);
                int line = bc.info.getLineOfRegion(region);
                String msg = null;
                msg = bm.length() == 0 ? String.format(BuildMessages.get("build.notbeempty"), name) : String.format(BuildMessages.get("build.notexists"), name, bm);
                AuroraBuilder.addMarker(bc.file, msg, line + 1, region, BuildContext.LEVEL_UNDEFINED_BM, "aurora.ide.undefinedBM");
            }
        }
    }

    public void processComplete(IFile file, CompositeMap map, IDocument doc) {
    }
}

