/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.search.core.AbstractSearchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.ComplexType;
import uncertain.schema.Element;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SxsdUtil {
    public static final QualifiedName ANY_ELEMENT = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "AnyElement");
    private static HashMap<String, List<Element>> childElementCache = new HashMap(1000);

    public static List<Attribute> getAttributesNotNull(CompositeMap map) throws Exception {
        Element ele = LoadSchemaManager.getSchemaManager().getElement(map);
        if (ele == null) {
            return new ArrayList<Attribute>();
        }
        List list = ele.getAllAttributes();
        if (list == null) {
            return new ArrayList<Attribute>();
        }
        return list;
    }

    public static Element getMapElement(CompositeMap map) {
        Element element = null;
        try {
            element = LoadSchemaManager.getSchemaManager().getElement(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static List<Element> getAvailableChildElements1(CompositeMap map) {
        Element element = SxsdUtil.getMapElement(map);
        if (element == null) {
            return null;
        }
        LinkedList<Element> childElements = new LinkedList();
        if (element.isArray()) {
            IType type = element.getElementType();
            if (type instanceof Element) {
                Element arrayType = LoadSchemaManager.getSchemaManager().getElement(type.getQName());
                childElements.add(arrayType);
            } else if (type instanceof ComplexType) {
                childElements.addAll(LoadSchemaManager.getSchemaManager().getElementsOfType(type));
            }
        } else {
            childElements = SxsdUtil.getChildElements(map);
        }
        if (childElements != null) {
            Collections.sort(childElements);
        }
        return childElements;
    }

    private static List<Element> getChildElements(CompositeMap map) {
        Element element = SxsdUtil.getMapElement(map);
        ArrayList<Element> availableChilds = new ArrayList<Element>();
        if (element == null) {
            return availableChilds;
        }
        Set schemaChilds = CompositeMapUtil.getSchemaChilds(element, LoadSchemaManager.getSchemaManager());
        if (schemaChilds != null) {
            for (Object object : schemaChilds) {
                if (!(object instanceof Element)) continue;
                Element ele = (Element)object;
                availableChilds.add(ele);
            }
        }
        return availableChilds;
    }

    public static List<Element> getAvailableChildElements(CompositeMap map) {
        Element ele;
        String key = String.valueOf(SxsdUtil.notNull(map.getNamespaceURI())) + ":" + map.getName();
        List<Element> childs = childElementCache.get(key);
        if (childs != null) {
            return childs;
        }
        childs = SxsdUtil.getAvailableChildElements1(map);
        if (childs == null) {
            childs = new ArrayList<Element>();
        }
        if ((ele = SxsdUtil.getMapElement(map)) != null) {
            childs.addAll(ele.getAllArrays());
        }
        childElementCache.put(key, childs);
        return childs;
    }

    public static String getHtmlDocument(CompositeMap mapNode) {
        List<Attribute> list;
        if (mapNode.getNamespaceURI() == null) {
            return String.valueOf(mapNode.getName()) + " \u6ca1\u6709\u547d\u540d\u7a7a\u95f4,\u627e\u4e0d\u5230\u6587\u6863";
        }
        StringBuilder sb = new StringBuilder(6144);
        try {
            list = SxsdUtil.getAttributesNotNull(mapNode);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return e1.getMessage();
        }
        if (list.size() == 0) {
            sb.append(String.format("[ %s ] \u4e2d\u6ca1\u6709\u5b9a\u4e49\u7684\u5c5e\u6027.<br/>", mapNode.getName()));
        } else {
            sb.append(String.format("[ %s ] \u4e2d\u5b9a\u4e49\u8fc7\u7684\u5c5e\u6027 :<br/><table><tr><th>\u5c5e\u6027\u540d</th><th>\u8bf4\u660e</th><th>\u7c7b\u578b</th></tr>", mapNode.getName()));
            for (Attribute a : list) {
                sb.append(String.format("<tr><td>%s</td><td>%s</td><td>%s</td></tr>", a.getName(), SxsdUtil.convertToHTMLContent(SxsdUtil.notNull(a.getDocument())), SxsdUtil.getTypeNameNotNull(a)));
            }
            sb.append("</table><br/>");
        }
        List<Element> childs = SxsdUtil.getAvailableChildElements(mapNode);
        if (childs.size() == 0) {
            sb.append(String.format("[ %s ] \u4e2d\u6ca1\u6709\u5b9a\u4e49\u7684\u5b50\u8282\u70b9.<br/>", mapNode.getName()));
        } else {
            sb.append(String.format("[ %s ] \u4e2d\u5b9a\u4e49\u8fc7\u7684\u5b50\u8282\u70b9 :<br/><table><tr><th>\u8282\u70b9\u540d</th><th>\u8bf4\u660e</th><th>\u6700\u5927\u91cd\u590d\u6b21\u6570</th></tr>", mapNode.getName()));
            for (Element e : childs) {
                sb.append(String.format("<tr><td>%s</td><td>%s</td><td>%s</td></tr>", e.getQName().getLocalName(), SxsdUtil.convertToHTMLContent(SxsdUtil.notNull(e.getDocument())), e.getMaxOccurs() == null ? "\u221e" : e.getMaxOccurs()));
            }
            sb.append("</table><br/>");
        }
        return sb.toString();
    }

    public static String convertToHTMLContent(String content) {
        content = content.replace("&", "&amp;");
        content = content.replace("\"", "&quot;");
        content = content.replace("'", "&apos;");
        content = content.replace("<", "&lt;");
        return content.replace(">", "&gt;");
    }

    public static String getTypeNameNotNull(Attribute a) {
        QualifiedName qfn = a.getTypeQName();
        if (qfn == null) {
            return "";
        }
        String name = qfn.getLocalName();
        if (name == null) {
            return "";
        }
        return name;
    }

    public static String notNull(String str) {
        return str == null ? "" : str;
    }

    public static boolean isDataSetReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.datasetReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static boolean isLocalFieldReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.localFieldReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static boolean isForeignFieldReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.foreignFieldReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static boolean isBMReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.bmReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static boolean isScreenReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.screenReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static boolean isURLReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.urlReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static boolean isExtOfAnyElement(Element elem) {
        return elem.isExtensionOf((IType)LoadSchemaManager.getSchemaManager().getComplexType(ANY_ELEMENT));
    }
}

