/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder;

import aurora.ide.AuroraMetaProjectNature;
import aurora.ide.AuroraProjectNature;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    public static final IFile getBMFile(IProject proj, String clsPath) {
        if (clsPath == null || proj == null) {
            return null;
        }
        String path = String.valueOf(clsPath.replace('.', '/')) + '.' + "bm";
        String bmhome = ResourceUtil.getBMHome(proj);
        if (bmhome.length() == 0) {
            return null;
        }
        String fullPath = String.valueOf(bmhome) + '/' + path;
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public static final IFile getFileUnderWebHome(IProject proj, String path) {
        String webHome = ResourceUtil.getWebHome(proj);
        if (webHome.length() == 0) {
            return null;
        }
        String fullPath = String.valueOf(webHome) + '/' + path;
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public static final String getBMHome(IProject proj) {
        IFolder folder = ResourceUtil.getBMHomeFolder(proj);
        if (folder == null) {
            return "";
        }
        return folder.getFullPath().toString();
    }

    public static final IFolder getBMHomeFolder(IProject proj) {
        if (!ResourceUtil.isAuroraProject(proj)) {
            return null;
        }
        String bmHome = null;
        try {
            bmHome = proj.getPersistentProperty(ProjectPropertyPage.BMQN);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (bmHome == null || bmHome.length() == 0) {
            IFolder wiFolder = ResourceUtil.searchWebInf((IResource)proj);
            if (wiFolder == null) {
                return null;
            }
            return wiFolder.getFolder("classes");
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(bmHome));
    }

    public static String getBmPkgPath(IFile bmFile) {
        IPath bmfilepath;
        if (bmFile == null) {
            return "";
        }
        IProject project = bmFile.getProject();
        IFolder bmhome = ResourceUtil.getBMHomeFolder(project);
        if (bmhome == null) {
            return "";
        }
        IPath bmhomepath = bmhome.getFullPath();
        if (!bmhomepath.isPrefixOf(bmfilepath = bmFile.getFullPath())) {
            return "";
        }
        IPath path = bmfilepath.makeRelativeTo(bmhomepath);
        path = path.removeFileExtension();
        return path.toString().replace('/', '.');
    }

    public static final String getWebHome(IProject proj) {
        if (!ResourceUtil.isAuroraProject(proj)) {
            return "";
        }
        String webHome = null;
        try {
            webHome = proj.getPersistentProperty(ProjectPropertyPage.WebQN);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (webHome == null || webHome.length() == 0) {
            IFolder wiFolder = ResourceUtil.searchWebInf((IResource)proj);
            if (wiFolder == null) {
                return "";
            }
            return wiFolder.getParent().getFullPath().toString();
        }
        return webHome;
    }

    public static final IFolder getWebHomeFolder(IProject proj) {
        if (!ResourceUtil.isAuroraProject(proj)) {
            return null;
        }
        String webHome = null;
        try {
            webHome = proj.getPersistentProperty(ProjectPropertyPage.WebQN);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (webHome == null || webHome.length() == 0) {
            IFolder wiFolder = ResourceUtil.searchWebInf((IResource)proj);
            if (wiFolder == null) {
                return null;
            }
            return (IFolder)wiFolder.getParent();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(webHome));
    }

    public static final boolean isAuroraProject(IProject proj) {
        if (proj == null || !proj.exists() || !proj.isOpen()) {
            return false;
        }
        try {
            return AuroraProjectNature.hasAuroraNature(proj);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final boolean isAuroraMetaProject(IProject proj) {
        if (proj == null || !proj.exists() || !proj.isOpen()) {
            return false;
        }
        try {
            return AuroraMetaProjectNature.hasAuroraNature(proj);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final IFolder searchWebInf(IResource resource) {
        if (resource == null) {
            return null;
        }
        IProject proj = resource.getProject();
        final IFolder[] results = new IFolder[1];
        try {
            proj.accept(new IResourceVisitor(){

                public boolean visit(IResource res) throws CoreException {
                    if (res.getName().equals("WEB-INF")) {
                        results[0] = (IFolder)res;
                        return false;
                    }
                    return true;
                }
            }, 2, 2);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return results[0];
    }

    public static final IFolder getWebInf(IResource resource) {
        if (resource == null) {
            return null;
        }
        String webHome = ResourceUtil.getWebHome(resource.getProject());
        if (webHome.length() == 0) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(String.valueOf(webHome) + '/' + "WEB-INF");
        if (res instanceof IFolder) {
            return (IFolder)res;
        }
        return null;
    }

    public static final ArrayList<IFolder> findAllWebInf(IProject proj) {
        final ArrayList<IFolder> als = new ArrayList<IFolder>();
        try {
            proj.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if ("WEB-INF".equals(resource.getName())) {
                        als.add((IFolder)resource);
                    }
                    return true;
                }
            }, 2, 2);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return als;
    }
}

