/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class RegionUtil {
    public static boolean isInRegion(IRegion region, int offset) {
        if (region == null) {
            return false;
        }
        return offset >= region.getOffset() && offset <= region.getOffset() + region.getLength();
    }

    public static boolean isSubRegion(IRegion region1, IRegion region2) {
        if (region1 == null || region2 == null) {
            return false;
        }
        return RegionUtil.isInRegion(region1, region2.getOffset()) && RegionUtil.isInRegion(region1, region2.getOffset() + region2.getLength());
    }

    public static IRegion intersect(IRegion region1, IRegion region2) {
        if (region1 == null || region2 == null) {
            return null;
        }
        int offset = Math.max(region1.getOffset(), region2.getOffset());
        int offset2 = Math.min(region1.getOffset() + region1.getLength(), region2.getOffset() + region2.getLength());
        if (offset2 < offset) {
            return null;
        }
        Region region = new Region(offset, offset2 - offset);
        return region;
    }

    public static IRegion union(IRegion region1, IRegion region2) {
        if (region1 == null || region2 == null) {
            return null;
        }
        int offset = Math.min(region1.getOffset(), region2.getOffset());
        int offset2 = Math.max(region1.getOffset() + region1.getLength(), region2.getOffset() + region2.getLength());
        Region region = new Region(offset, offset2 - offset);
        return region;
    }
}

