/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder;

import aurora.ide.AuroraPlugin;
import aurora.ide.AuroraProjectNature;
import aurora.ide.builder.validator.IntimeValidator;
import aurora.ide.editor.textpage.IReconcileListener;
import aurora.ide.preferencepages.CustomSettingPreferencePage;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;

public class IntimeBuilder
implements IReconcileListener {
    private ISourceViewer sourceViewer;
    private IFile file;

    public IntimeBuilder(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public void reconcile() {
        if (!CustomSettingPreferencePage.getIntimeBuildEnable()) {
            return;
        }
        IAnnotationModel am = this.sourceViewer.getAnnotationModel();
        Iterator itr = am.getAnnotationIterator();
        while (itr.hasNext()) {
            Annotation anno = (Annotation)itr.next();
            if (anno.getText() == null || !anno.getClass().equals(Annotation.class)) continue;
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IntimeBuilder.this.file = AuroraPlugin.getActiveIFile();
                    if (IntimeBuilder.this.file == null) {
                        return;
                    }
                    if (!AuroraProjectNature.hasAuroraNature(IntimeBuilder.this.file.getProject())) {
                        return;
                    }
                    IDocument doc = IntimeBuilder.this.sourceViewer.getDocument();
                    new IntimeValidator(IntimeBuilder.this.file, doc).validate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

