/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder;

import aurora.ide.builder.RegionUtil;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.search.core.Util;
import java.util.HashMap;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.RGB;
import uncertain.composite.CompositeMap;
import uncertain.util.resource.Location;

public class CompositeMapInfo {
    private IDocument rootDoc;
    private CompositeMap currentMap;
    private IRegion startRegion;
    private IRegion endRegion;
    private IRegion mapRegion;
    private IRegion mapNameRegion;
    private IRegion mapEndTagNameRegion;
    private String prefix;
    private HashMap<String, Object[]> attrMap = new HashMap(10);
    private int startLine;
    private int endLine;

    public CompositeMapInfo(CompositeMap map, IDocument rootDoc) {
        this.currentMap = map;
        this.rootDoc = rootDoc;
        try {
            this.regionMapping();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void regionMapping() throws Exception {
        Location loc = this.currentMap.getLocationNotNull();
        this.startLine = loc.getStartLine() - 1;
        this.endLine = loc.getEndLine() - 1;
        String mapName = this.currentMap.getName();
        String pre = this.currentMap.getPrefix();
        int startOffset = this.computeStartOffset(this.startLine, loc.getStartColumn() - 1);
        int endOffset = this.rootDoc.getLineOffset(this.endLine) + loc.getEndColumn() - 1;
        ITypedRegion[] typedRegion = this.rootDoc.computePartitioning(startOffset, endOffset - startOffset);
        boolean findStartTag = false;
        ITypedRegion[] iTypedRegionArray = typedRegion;
        int n = typedRegion.length;
        int n2 = 0;
        while (n2 < n) {
            int idx;
            ITypedRegion tr = iTypedRegionArray[n2];
            String type = tr.getType();
            int ln = this.rootDoc.getLineOfOffset(tr.getOffset() + tr.getLength());
            int off = this.rootDoc.getLineOffset(ln);
            if (!findStartTag && "XML_START_TAG".equals(type)) {
                if (loc.getStartColumn() - 1 == tr.getOffset() + tr.getLength() - off) {
                    this.getPrefix(startOffset);
                    this.mapRegion = new Region(startOffset, endOffset - startOffset);
                    this.startRegion = new Region(startOffset, tr.getLength());
                    idx = startOffset + 1;
                    if (pre != null) {
                        idx += pre.length() + 1;
                    }
                    this.mapNameRegion = new Region(idx, mapName.length());
                    this.attrMapping(startOffset, tr.getLength());
                    findStartTag = true;
                }
            } else if ("XML_END_TAG".equals(type) && endOffset == tr.getOffset() + tr.getLength()) {
                this.endRegion = new Region(tr.getOffset(), tr.getLength());
                idx = tr.getOffset() + 2;
                if (pre != null) {
                    idx += pre.length() + 1;
                }
                this.mapEndTagNameRegion = new Region(idx, mapName.length());
                break;
            }
            ++n2;
        }
        if (this.endRegion == null) {
            this.endRegion = this.startRegion;
            this.mapEndTagNameRegion = this.mapNameRegion;
        }
    }

    private void attrMapping(int offset, int length) throws Exception {
        XMLTagScanner scanner = Util.getXMLTagScanner();
        scanner.setRange(this.rootDoc, offset, length);
        IToken token = Token.EOF;
        String lastAttr = null;
        Object[] objs = null;
        while ((token = scanner.nextToken()) != Token.EOF) {
            Object data = token.getData();
            if (!(data instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)data;
            RGB rgb = text.getForeground().getRGB();
            offset = scanner.getTokenOffset();
            length = scanner.getTokenLength();
            if (IColorConstants.ATTRIBUTE.equals((Object)rgb)) {
                lastAttr = this.rootDoc.get(offset, length);
                objs = new Object[3];
                objs[1] = new Region(offset, length);
                continue;
            }
            if (!IColorConstants.STRING.equals((Object)rgb)) continue;
            objs[0] = this.rootDoc.get(offset + 1, length - 2);
            objs[2] = new Region(offset, length);
            this.attrMap.put(lastAttr, objs);
        }
    }

    private int computeStartOffset(int startLine, int startColumn) throws Exception {
        char c;
        int lo = this.rootDoc.getLineOffset(startLine);
        int startOffset = lo + startColumn - 1;
        while ((c = this.rootDoc.getChar(startOffset)) != '<') {
            --startOffset;
        }
        return startOffset;
    }

    public IRegion getMapRegion() {
        return this.mapRegion;
    }

    private void getPrefix(int offset) throws Exception {
        int line = this.rootDoc.getLineOfOffset(offset);
        int lineOffset = this.rootDoc.getLineOffset(line);
        String str = this.rootDoc.get(lineOffset, offset - lineOffset);
        char[] cs = str.toCharArray();
        int i = 0;
        while (i < cs.length) {
            if (!Character.isWhitespace(cs[i])) {
                cs[i] = 32;
            }
            ++i;
        }
        this.prefix = new String(cs);
    }

    public String getLeadPrefix() {
        return this.prefix;
    }

    public IRegion getMapNameRegion() {
        return this.mapNameRegion;
    }

    public IRegion getMapEntTagNameRegion() {
        return this.mapEndTagNameRegion;
    }

    public IRegion getAttrNameRegion(String attrName) {
        Object[] objs = this.attrMap.get(attrName);
        if (objs == null) {
            return null;
        }
        return (Region)objs[1];
    }

    public IRegion getAttrValueRegion(String attrName) {
        Object[] objs = this.attrMap.get(attrName);
        if (objs == null) {
            return null;
        }
        return (Region)objs[2];
    }

    public IRegion getAttrValueRegion2(String attrName) {
        Object[] objs = this.attrMap.get(attrName);
        if (objs == null || objs[2] == null) {
            return null;
        }
        Region region = (Region)objs[2];
        if (region.getLength() == 2) {
            return region;
        }
        return new Region(region.getOffset() + 1, region.getLength() - 2);
    }

    public IRegion getAttrRegion(String attrName) {
        Object[] objs = this.attrMap.get(attrName);
        if (objs == null || objs[1] == null || objs[2] == null) {
            return null;
        }
        Region sr = (Region)objs[1];
        Region er = (Region)objs[2];
        return RegionUtil.union((IRegion)sr, (IRegion)er);
    }

    public IRegion getStartTagRegion() {
        return this.startRegion;
    }

    public IRegion getEndTagRegion() {
        return this.endRegion;
    }

    public String getAttrRealValue(String attrName) {
        Object[] objs = this.attrMap.get(attrName);
        if (objs == null) {
            return null;
        }
        return (String)objs[0];
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void print() {
        System.out.println("MapName     : " + this.currentMap.getName());
        System.out.println("MapRegion   : " + this.mapRegion);
        System.out.println("NameRegion  : " + this.mapNameRegion);
        System.out.println("StartRegion : " + this.startRegion);
        System.out.println("EndRegion   : " + this.endRegion);
        int maxKeyLength = 0;
        int maxValueLength = 0;
        for (String s : this.attrMap.keySet()) {
            String v;
            if (s.length() > maxKeyLength) {
                maxKeyLength = s.length();
            }
            if ((v = (String)this.attrMap.get(s)[0]) == null || v.length() <= maxValueLength) continue;
            maxValueLength = v.length();
        }
        for (String s : this.attrMap.keySet()) {
            Object[] objs = this.attrMap.get(s);
            System.out.printf("%-" + (maxKeyLength + 1) + "s= %-" + (maxValueLength + 1) + "s %s ~~~~~ %s \n", s, objs[0], objs[1], objs[2]);
        }
        System.out.println();
    }

    public int getLineOfRegion(IRegion region) {
        try {
            return this.rootDoc.getLineOfOffset(region.getOffset());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public CompositeMap getCompositeMap() {
        return this.currentMap;
    }

    public IDocument getDocument() {
        return this.rootDoc;
    }
}

