/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder;

import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.builder.validator.BmValidator;
import aurora.ide.builder.validator.ScreenValidator;
import aurora.ide.builder.validator.SvcValidator;
import aurora.ide.builder.validator.UncertainLocalValidator;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import aurora.ide.search.ui.MessageFormater;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;

public class AuroraBuilder
extends IncrementalProjectBuilder {
    private int filecount = 0;
    private IPath webPath;
    private ArrayList<IResource> filesToBuild = new ArrayList();
    public static final String BUILDER_ID = "aurora.ide.auroraBuilder";
    public static final String UNDEFINED_ATTRIBUTE = "aurora.ide.undefinedAttribute";
    public static final String UNDEFINED_BM = "aurora.ide.undefinedBM";
    public static final String UNDEFINED_DATASET = "aurora.ide.undefinedDataSet";
    public static final String UNDEFINED_FOREIGNFIELD = "aurora.ide.undefinedForeignField";
    public static final String UNDEFINED_LOCALFIELD = "aurora.ide.undefinedLocalField";
    public static final String UNDEFINED_SCREEN = "aurora.ide.undefinedScreen";
    public static final String NONENAMESPACE = "aurora.ide.nonenamespace";
    public static final String CONFIG_PROBLEM = "aurora.ide.configProblem";
    public static final String UNDEFINED_TAG = "aurora.ide.undefinedTag";
    public static final String FATAL_ERROR = "aurora.ide.fatalError";
    private static String[] definedMarkerTypes = new String[]{"aurora.ide.undefinedAttribute", "aurora.ide.undefinedBM", "aurora.ide.undefinedDataSet", "aurora.ide.undefinedForeignField", "aurora.ide.undefinedLocalField", "aurora.ide.undefinedScreen", "aurora.ide.nonenamespace", "aurora.ide.configProblem", "aurora.ide.undefinedTag", "aurora.ide.fatalError"};
    protected IResource fCurrentResource;
    protected int fNumberOfScannedFiles;
    private Job updateMonitorJob;

    public static IMarker addMarker(IFile file, String message, int lineNumber, int severity, String markerType) {
        try {
            IMarker marker = file.createMarker(markerType);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
            return marker;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IMarker addMarker(IFile file, String message, int line, int start, int length, int severity, String markerType) {
        try {
            IMarker marker = file.createMarker(markerType);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", line);
            marker.setAttribute("charStart", start);
            marker.setAttribute("charEnd", start + length);
            return marker;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IMarker addMarker(IFile file, String msg, int lineno, IRegion region, int sevrity, String markerType) {
        if (region == null) {
            return AuroraBuilder.addMarker(file, msg, lineno, sevrity, markerType);
        }
        return AuroraBuilder.addMarker(file, msg, lineno, region.getOffset(), region.getLength(), sevrity, markerType);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        BuildContext.initBuildLevel();
        this.updateMonitorJob = this.createJob(monitor);
        this.fNumberOfScannedFiles = 0;
        this.filesToBuild.clear();
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                return null;
            }
            this.incrementalBuild(delta, monitor);
        }
        return null;
    }

    private Job createJob(final IProgressMonitor monitor) {
        return new Job("Aurora build progress"){
            private int fLastNumberOfScannedFiles;
            {
                super($anonymous0);
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    final IResource res = AuroraBuilder.this.fCurrentResource;
                    if (res != null) {
                        if (!this.isRunInUI()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    this.updateMonitor(monitor, res);
                                }
                            });
                        } else {
                            this.updateMonitor(monitor, res);
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }

            private boolean isRunInUI() {
                return true;
            }

            private void updateMonitor(IProgressMonitor monitor2, IResource res) {
                String fileName = res.getName();
                Object[] args = new Object[]{fileName, AuroraBuilder.this.fNumberOfScannedFiles, AuroraBuilder.this.filecount};
                monitor2.subTask(MessageFormater.format("Scanning file {1} of {2}: {0}", args));
                int steps = AuroraBuilder.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                monitor2.worked(steps);
                this.fLastNumberOfScannedFiles += steps;
            }
        };
    }

    public static void deleteMarkers(IFile file) {
        try {
            String[] stringArray = definedMarkerTypes;
            int n = definedMarkerTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                file.deleteMarkers(s, false, 0);
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            if (!this.checkWebDir()) {
                return;
            }
            try {
                this.getProject().accept((IResourceVisitor)new ResourceCountVisitor());
                monitor.beginTask("builder " + this.getProject().getName(), this.filecount);
                this.updateMonitorJob.setSystem(true);
                this.updateMonitorJob.schedule();
                this.getProject().accept((IResourceVisitor)new SampleResourceVisitor());
                for (IResource res : this.filesToBuild) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    this.validate(res);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.updateMonitorJob.cancel();
            monitor.done();
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        if (!this.checkWebDir()) {
            return;
        }
        delta.accept((IResourceDeltaVisitor)new ResourceCountVisitor());
        monitor.beginTask("builder " + this.getProject().getName(), this.filecount);
        this.updateMonitorJob.setSystem(true);
        this.updateMonitorJob.schedule();
        try {
            delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
            for (IResource res : this.filesToBuild) {
                if (monitor.isCanceled()) {
                    break;
                }
                this.validate(res);
            }
        }
        finally {
            this.updateMonitorJob.cancel();
            monitor.done();
        }
    }

    private boolean checkWebDir() throws CoreException {
        IProject project = this.getProject();
        project.deleteMarkers(CONFIG_PROBLEM, false, 0);
        String webdir = project.getPersistentProperty(ProjectPropertyPage.WebQN);
        if (webdir == null) {
            IMarker marker;
            ArrayList<IFolder> als = ResourceUtil.findAllWebInf(project);
            for (IFolder f : als) {
                f.deleteMarkers(CONFIG_PROBLEM, false, 0);
            }
            if (als.size() > 1) {
                marker = als.get(1).createMarker(CONFIG_PROBLEM);
                marker.setAttribute("message", (Object)BuildMessages.get("build.webinfo.muliti"));
                marker.setAttribute("severity", 2);
                return false;
            }
            if (als.size() == 0) {
                marker = project.createMarker(CONFIG_PROBLEM);
                marker.setAttribute("message", (Object)BuildMessages.get("build.web.notexists"));
                marker.setAttribute("severity", 2);
                return false;
            }
            IFolder webinf = als.get(0);
            this.webPath = webinf.getParent().getFullPath();
            project.setPersistentProperty(ProjectPropertyPage.WebQN, this.webPath.toString());
            project.setPersistentProperty(ProjectPropertyPage.BMQN, webinf.getFolder("classes").getFullPath().toString());
        } else {
            this.webPath = new Path(webdir);
        }
        return true;
    }

    private void validate(IResource resource) {
        this.fCurrentResource = resource;
        ++this.fNumberOfScannedFiles;
        if (!this.webPath.isPrefixOf(resource.getFullPath())) {
            return;
        }
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.validateFile(file);
        }
    }

    private void validateFile(IFile file) {
        AuroraBuilder.deleteMarkers(file);
        String ext = file.getFileExtension();
        if (ext != null) {
            ext = ext.toLowerCase();
        }
        if (file.getName().equalsIgnoreCase("uncertain.local.xml")) {
            new UncertainLocalValidator(file).validate();
        } else if ("bm".equals(ext)) {
            new BmValidator(file).validate();
        } else if ("svc".equals(ext)) {
            new SvcValidator(file).validate();
        } else if ("screen".equals(ext)) {
            new ScreenValidator(file).validate();
        } else {
            "config".equals(ext);
        }
    }

    public static String[] getDefinedMarkerTypes() {
        return definedMarkerTypes;
    }

    private class ResourceCountVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        public ResourceCountVisitor() {
            AuroraBuilder.this.filecount = 0;
        }

        public boolean visit(IResource resource) throws CoreException {
            AuroraBuilder auroraBuilder = AuroraBuilder.this;
            auroraBuilder.filecount = auroraBuilder.filecount + 1;
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            AuroraBuilder auroraBuilder = AuroraBuilder.this;
            auroraBuilder.filecount = auroraBuilder.filecount + 1;
            return true;
        }
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    AuroraBuilder.this.filesToBuild.add(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    AuroraBuilder.this.filesToBuild.add(resource);
                }
            }
            return true;
        }
    }

    class SampleResourceVisitor
    implements IResourceVisitor {
        SampleResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            AuroraBuilder.this.filesToBuild.add(resource);
            return true;
        }
    }
}

