/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.table;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.SystemException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;

public class RegisterDescription {
    public static final String SYS_PROMPTS_TABLE = "sys_prompts";
    public static int CREATED_BY = 1;
    public static String CREATION_DATE = "sysdate";
    public static String LANGUAGE = "ZHS";
    private HashMap promptList = new HashMap();
    private Connection connection;

    public RegisterDescription(Connection connection) {
        this.connection = connection;
    }

    public void addPrompt(String prompt_code, String description) {
        this.promptList.put(prompt_code, description);
    }

    public HashMap getPromptList() {
        return this.promptList;
    }

    public void setPromptList(HashMap promptList) {
        this.promptList = promptList;
    }

    public void run() throws ApplicationException {
        if (this.promptList.keySet() == null) {
            return;
        }
        String selectSQL = "select 1 from sys_prompts t where t.prompt_code=? and t.language=?";
        String insertSQL = " insert into sys_prompts(prompt_id,prompt_code,language,description,created_by,creation_date,last_updated_by,last_update_date)values(sys_prompts_s.nextval,?,?,?,?,sysdate,?,sysdate)";
        String databaseProductName = "";
        try {
            DatabaseMetaData m = this.connection.getMetaData();
            databaseProductName = m.getDatabaseProductName();
        }
        catch (SQLException e1) {
            DialogUtil.logErrorException(e1);
        }
        if (!"Oracle".equalsIgnoreCase(databaseProductName)) {
            DialogUtil.showErrorMessageBox("\u6ce8\u518c\u63cf\u8ff0\u529f\u80fd\u6682\u65f6\u53ea\u652f\u6301Oracle\u6570\u636e\u5e93");
        }
        Set keySet = this.promptList.keySet();
        Statement queryPS = null;
        Statement insertPS = null;
        try {
            try {
                this.connection.setAutoCommit(false);
                queryPS = this.connection.prepareStatement(selectSQL);
                insertPS = this.connection.prepareStatement(insertSQL);
                for (String prompt_code : keySet) {
                    String description = (String)this.promptList.get(prompt_code);
                    queryPS.setString(1, prompt_code);
                    queryPS.setString(2, LANGUAGE);
                    if (!this.isNone(queryPS.executeQuery())) continue;
                    insertPS.setString(1, prompt_code);
                    insertPS.setString(2, LANGUAGE);
                    insertPS.setString(3, description);
                    insertPS.setInt(4, CREATED_BY);
                    insertPS.setInt(5, CREATED_BY);
                    insertPS.executeUpdate();
                }
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                throw new SystemException(e);
            }
        }
        finally {
            try {
                if (queryPS != null) {
                    queryPS.close();
                }
                if (insertPS != null) {
                    insertPS.close();
                }
            }
            catch (SQLException e) {
                DialogUtil.logErrorException(e);
                DialogUtil.showExceptionMessageBox(e);
            }
        }
    }

    public boolean isNone(ResultSet set) throws SystemException {
        if (set == null) {
            return true;
        }
        try {
            return !set.next();
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }
}

