/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.table;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.wizard.table.BMFromDBWizard;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.WizardPageRefreshable;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

public class BMTablePage
extends WizardPageRefreshable {
    public static final String FILE_EXT = "bm";
    private BMFromDBWizard wizard;
    private String tableName;
    private String tableRemarks;
    private final String[] columnNames = new String[]{"TABLE_NAME", "REMARKS", "TABLE_TYPE", "TABLE_SCHEM", "TABLE_CAT"};
    private final int REMARKS_INDEX = 1;
    private final String[] columnTitles = new String[]{"\u8868\u540d", "\u63cf\u8ff0", "\u7c7b\u578b", "\u6a21\u5f0f", "\u7f16\u76ee"};
    DatabaseMetaData dbMetaData;
    GridViewer gridViewer;
    private Text fileText;

    public BMTablePage(ISelection selection, BMFromDBWizard bmWizard) {
        super("wizardPage");
        this.setTitle(LocaleMessage.getString("business.model.editor.file"));
        this.setDescription(LocaleMessage.getString("bm.wizard.desc"));
        this.wizard = bmWizard;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        Composite gridComposite = new Composite(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 400;
        gridComposite.setLayoutData((Object)gd);
        gridComposite.setLayout((Layout)new GridLayout());
        CompositeMap input = null;
        try {
            Connection dbConnection = this.wizard.getConnection();
            this.dbMetaData = dbConnection.getMetaData();
            input = this.getInput(this.dbMetaData, "%");
        }
        catch (ApplicationException e) {
            e.printStackTrace();
            this.setErrorMessage(e.getCause().getMessage());
        }
        catch (SQLException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        this.gridViewer = new GridViewer(this.columnNames, 304);
        try {
            this.gridViewer.setFilterColumn("TABLE_NAME");
            this.gridViewer.setColumnTitles(this.columnTitles);
            this.gridViewer.createViewer(gridComposite);
            CellEditor[] celleditors = new CellEditor[this.columnNames.length];
            CellInfo cellProperties = new CellInfo(this.gridViewer, "REMARKS", false);
            StringTextCellEditor cellEditor = new StringTextCellEditor(cellProperties);
            celleditors[1] = cellEditor.getCellEditor();
            cellEditor.init();
            this.gridViewer.addEditor("REMARKS", cellEditor);
            this.gridViewer.setCellEditors(celleditors);
            this.gridViewer.setData(input);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        this.gridViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BMTablePage.this.getTableName() == null) {
                    BMTablePage.this.setPageComplete(false);
                } else {
                    BMTablePage.this.setPageComplete(true);
                    BMTablePage.this.fileText.setText(String.valueOf(BMTablePage.this.getTableName().toLowerCase()) + "." + BMTablePage.FILE_EXT);
                }
                try {
                    BMTablePage.this.wizard.refresh();
                }
                catch (ApplicationException e) {
                    DialogUtil.showExceptionMessageBox(e);
                    return;
                }
            }
        });
        Label label = new Label(container, 0);
        label.setText(LocaleMessage.getString("file.name"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BMTablePage.this.checkPageValues();
            }
        });
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    public String getContainerName() {
        return this.wizard.getContainerName();
    }

    public DatabaseMetaData getDBMetaData() {
        return this.dbMetaData;
    }

    public CompositeMap getPrimaryKeys() throws SQLException {
        CommentCompositeMap primaryKeyArray = new CommentCompositeMap(FILE_EXT, "http://www.aurora-framework.org/schema/bm", "primary-key");
        String tableName = this.getTableName();
        if (tableName == null) {
            return primaryKeyArray;
        }
        ResultSet tableRet = this.dbMetaData.getPrimaryKeys(null, this.dbMetaData.getUserName(), tableName);
        while (tableRet.next()) {
            CommentCompositeMap field = new CommentCompositeMap(FILE_EXT, "http://www.aurora-framework.org/schema/bm", "pk-field");
            field.put("name", tableRet.getString("COLUMN_NAME").toLowerCase());
            primaryKeyArray.addChild(field);
        }
        return primaryKeyArray;
    }

    public String getTableName() {
        CompositeMap record = this.gridViewer.getSelection();
        if (record == null) {
            return null;
        }
        this.tableName = record.getString((Object)"TABLE_NAME");
        return this.tableName;
    }

    public String getTableRemarks() {
        CompositeMap record = this.gridViewer.getSelection();
        if (record == null) {
            return null;
        }
        this.tableRemarks = record.getString((Object)"REMARKS");
        return this.tableRemarks;
    }

    private CompositeMap getInput(DatabaseMetaData DBMetaData, String tableNamePattern) throws SQLException {
        CommentCompositeMap input = new CommentCompositeMap();
        ResultSet tableRet = DBMetaData.getTables(null, DBMetaData.getUserName(), tableNamePattern, new String[]{"TABLE", "VIEW"});
        while (tableRet.next()) {
            int seq = 0;
            CommentCompositeMap element = new CommentCompositeMap();
            element.put(this.columnNames[seq], tableRet.getString(this.columnNames[seq++]));
            element.put(this.columnNames[seq], tableRet.getString(this.columnNames[seq++]));
            element.put(this.columnNames[seq], tableRet.getString(this.columnNames[seq++]));
            element.put(this.columnNames[seq], tableRet.getString(this.columnNames[seq++]));
            element.put(this.columnNames[seq], tableRet.getString(this.columnNames[seq++]));
            input.addChild(element);
        }
        return input;
    }

    public String getFileName() {
        String fileName = this.fileText.getText();
        if (fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + "." + FILE_EXT;
        }
        return fileName.toLowerCase();
    }

    public void checkPageValues() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updatePageStatus(LocaleMessage.getString("file.container.must.be.specified"));
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updatePageStatus(LocaleMessage.getString("file.container.must.exist"));
            return;
        }
        if (fileName != null && !fileName.equals("") && ((IContainer)container).getFile((IPath)new Path(fileName)).exists()) {
            this.updatePageStatus(LocaleMessage.getString("filename.used"));
            return;
        }
        if (!container.isAccessible()) {
            this.updatePageStatus(LocaleMessage.getString("project.must.be.writable"));
            return;
        }
        if (fileName.length() == 0) {
            this.updatePageStatus(LocaleMessage.getString("file.name.must.be.specified"));
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updatePageStatus(LocaleMessage.getString("file.name.must.be.valid"));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(FILE_EXT)) {
            this.updatePageStatus(LocaleMessage.getString("file.extension.must.be.bm"));
            return;
        }
        this.updatePageStatus(null);
    }
}

