/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.table;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.wizard.table.BMFieldsPage;
import aurora.ide.bm.wizard.table.BMMainConfigPage;
import aurora.ide.bm.wizard.table.BMTablePage;
import aurora.ide.bm.wizard.table.RegisterDescription;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.helpers.SystemException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.driver.OracleConnection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import uncertain.composite.CompositeMap;

public class BMFromDBWizard
extends Wizard
implements INewWizard {
    private BMMainConfigPage mainConfigPage;
    private BMTablePage tablePage;
    private BMFieldsPage fieldsPage;
    private ISelection selection;
    private CompositeMap initContent;
    private Connection connnect;
    private HashMap promptList = new HashMap();

    public BMFromDBWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainConfigPage = new BMMainConfigPage(this.selection, this);
        this.tablePage = new BMTablePage(this.selection, this);
        this.fieldsPage = new BMFieldsPage(this.selection, this);
        this.fieldsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.mainConfigPage);
        this.addPage((IWizardPage)this.tablePage);
        this.addPage((IWizardPage)this.fieldsPage);
    }

    public boolean performFinish() {
        final String containerName = this.mainConfigPage.getContainerName();
        final String fileName = this.tablePage.getFileName();
        try {
            this.initContent = this.createInitContent();
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return true;
        }
        final boolean registerPrompt = this.isAutoRegisterPrompt();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        BMFromDBWizard.this.doFinish(containerName, fileName, monitor);
                        if (registerPrompt) {
                            BMFromDBWizard.this.autoRegisterPrompt();
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        if (fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + ".bm";
        }
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            DialogUtil.showErrorMessageBox(String.valueOf(LocaleMessage.getString("container")) + " \"" + containerName + "\"" + LocaleMessage.getString("not.exist"));
            return;
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    public void autoRegisterPrompt() {
        try {
            RegisterDescription rd = new RegisterDescription(this.getConnection());
            rd.setPromptList(this.promptList);
            rd.run();
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    private InputStream openContentStream() throws SystemException {
        String xmlHint = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String contents = String.valueOf(xmlHint) + AuroraResourceUtil.LineSeparator + AuroraResourceUtil.getSign() + CommentXMLOutputter.defaultInstance().toXML(this.initContent);
        try {
            return new ByteArrayInputStream(contents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
    }

    private CompositeMap createInitContent() throws ApplicationException {
        CommentCompositeMap model = new CommentCompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "model");
        model.put("baseTable", this.getTableName());
        model.put("alias", "t1");
        this.addFieldsAndFeatures(model);
        try {
            CompositeMap pks = this.getPrimaryKeys();
            if (pks != null && pks.getChilds() != null) {
                model.addChild(pks);
            }
        }
        catch (SQLException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        return model;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public String getTableName() {
        return this.tablePage.getTableName();
    }

    public String getTableRemarks() {
        return this.tablePage.getTableRemarks();
    }

    public DatabaseMetaData getDBMetaData() {
        return this.tablePage.getDBMetaData();
    }

    public CompositeMap getPrimaryKeys() throws SQLException {
        return this.tablePage.getPrimaryKeys();
    }

    public void createPageControls(Composite pageContainer) {
    }

    private CompositeMap addFieldsAndFeatures(CompositeMap model) throws ApplicationException {
        if (model == null) {
            return null;
        }
        CommentCompositeMap features = new CommentCompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "features");
        CommentCompositeMap standardWho = new CommentCompositeMap("f", "aurora.database.features", "standard-who");
        features.addChild(standardWho);
        CompositeMap fields = this.fieldsPage.getSelectedFields();
        String descIdFieldName = "description_id";
        if (fields == null) {
            return model;
        }
        model.addChild(fields);
        model.addChild((CompositeMap)features);
        CompositeMap descIdField = fields.getChildByAttrib((Object)"name", (Object)descIdFieldName);
        if (descIdField == null) {
            return model;
        }
        descIdField.put((Object)"multiLanguage", (Object)"true");
        descIdField.put((Object)"multiLanguageDescField", (Object)"description");
        CommentCompositeMap descField = new CommentCompositeMap(fields.getPrefix(), fields.getNamespaceURI(), "field");
        descField.put("name", "description");
        descField.put("databaseType", "VARCHAR");
        descField.put("datatype", "java.lang.String");
        String prompt_code = String.valueOf(this.getTableName()) + ".DESCRIPTION";
        descField.put("prompt", prompt_code);
        if (this.getTableRemarks() != null) {
            String tableRemarks = this.getTableRemarks();
            int endIndex = tableRemarks.indexOf("\u8868");
            if (endIndex == -1) {
                endIndex = tableRemarks.length();
            }
            String descFieldPrompt = String.valueOf(tableRemarks.substring(0, endIndex)) + "\u63cf\u8ff0";
            this.promptList.put(prompt_code, descFieldPrompt);
        }
        fields.addChild((CompositeMap)descField);
        CommentCompositeMap multiLanguage = new CommentCompositeMap("f", "aurora.database.features", "multi-language-storage");
        features.addChild(multiLanguage);
        return model;
    }

    public Connection getConnection() throws ApplicationException {
        if (this.connnect == null) {
            this.connnect = DBConnectionUtil.getDBConnection(ProjectUtil.getIProjectFromSelection());
            if (this.connnect instanceof OracleConnection) {
                ((OracleConnection)this.connnect).setRemarksReporting(true);
            }
        }
        return this.connnect;
    }

    public void refresh() throws ApplicationException {
        if (this.fieldsPage.getControl() != null) {
            this.fieldsPage.refresh();
        }
    }

    public boolean isAutoRegisterPrompt() {
        return this.mainConfigPage.getAutoRegisterPromptButton().getSelection();
    }

    public void addPrompt(String prompt_code, String description) {
        this.promptList.put(prompt_code, description);
    }

    public String getContainerName() {
        return this.mainConfigPage.getContainerName();
    }
}

