/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.sql;

import aurora.ide.api.composite.map.CommentCompositeMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import uncertain.composite.CompositeMap;
import uncertain.util.TagParseHandle;
import uncertain.util.TagProcessor;
import uncertain.util.UnixShellTagProcessor;

public class CompositeMapTagParser {
    TagProcessor processor;

    public CompositeMapTagParser(TagProcessor processor) {
        this.processor = processor;
    }

    public CompositeMapTagParser() {
        this.processor = new UnixShellTagProcessor();
    }

    void appendString(int index, TagProcessor processor, TagParseHandle handle) {
        String tag = processor.getTagString();
        if (tag != null && tag.length() > 0) {
            handle.ProcessTag(index, tag);
        }
    }

    private CompositeMap parse(Reader reader, ParameterHandle handle) throws IOException {
        int ch;
        int index = 0;
        int tag_begin = 0;
        char tag_chr = this.processor.getStartingEscapeChar();
        this.processor.setEscapeState(false);
        while ((ch = reader.read()) != -1) {
            char chr = (char)ch;
            if (!this.processor.isEscapeState()) {
                if (tag_chr == chr) {
                    this.processor.setEscapeState(true);
                    tag_begin = index;
                }
            } else if (this.processor.accept(chr) != 0) {
                this.processor.setEscapeState(false);
                this.appendString(tag_begin, this.processor, handle);
            }
            ++index;
        }
        if (this.processor.isEscapeState()) {
            this.appendString(tag_begin, this.processor, handle);
        }
        return handle.getParameters();
    }

    public void clear() {
        this.processor.clear();
        this.processor = null;
    }

    public static void main(String[] args) {
        UnixShellTagProcessor pr = new UnixShellTagProcessor();
        CompositeMapTagParser parser = new CompositeMapTagParser((TagProcessor)pr);
        CompositeMap s = parser.parse(new String("begininsert into  emp ( empno, ename, deptno, creation_date, created_by ) values ( emp_s.nextval, ${/session/@user_id}, ${@deptno}, sysdate, ${/session/@user_id})returning empno into ${@empno};end;"));
        System.out.println(s.toXML());
    }

    public CompositeMap parse(String str) {
        if (str == null) {
            return null;
        }
        try {
            return this.parse(new StringReader(str), new ParameterHandle());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public class ParameterHandle
    implements TagParseHandle {
        String bm_uri = "http://www.aurora-framework.org/schema/bm";
        String bm_pre = "bm";
        CompositeMap parameters = new CommentCompositeMap(this.bm_pre, this.bm_uri, "parameters");

        public String ProcessTag(int index, String tag) {
            CommentCompositeMap child = new CommentCompositeMap(this.bm_pre, this.bm_uri, "parameter");
            if (tag.startsWith("@")) {
                child.put("name", tag.substring(1));
            } else {
                child.put("inputPath", tag);
            }
            if (this.parameters.getChild((CompositeMap)child) == null) {
                this.parameters.addChild((CompositeMap)child);
            }
            return tag;
        }

        public int ProcessCharacter(int index, char ch) {
            return ch;
        }

        public CompositeMap getParameters() {
            return this.parameters;
        }
    }
}

