/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.sql;

import aurora.ide.helpers.LocaleMessage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class BMFromSQLWizardPage
extends WizardPage {
    public static final String FILE_EXT = "bm";
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private StyledText innerText;

    public BMFromSQLWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(LocaleMessage.getString("business.model.editor.file"));
        this.setDescription(LocaleMessage.getString("bm.wizard.desc"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(LocaleMessage.getString("container"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BMFromSQLWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(LocaleMessage.getString("openBrowse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BMFromSQLWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(LocaleMessage.getString("file.name"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BMFromSQLWizardPage.this.dialogChanged();
            }
        });
        Group SQLText = new Group(container, 0);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        SQLText.setLayoutData((Object)gd);
        SQLText.setText(LocaleMessage.getString("enter.sql"));
        SQLText.setLayout((Layout)new FillLayout());
        this.innerText = new StyledText((Composite)SQLText, 576);
        this.innerText.setFont(new Font((Device)SQLText.getDisplay(), "Courier New", 10, 0));
        this.innerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BMFromSQLWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LocaleMessage.getString("select.new.file.container"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(LocaleMessage.getString("file.container.must.be.specified"));
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(LocaleMessage.getString("file.container.must.exist"));
            return;
        }
        if (fileName != null && !fileName.equals("") && ((IContainer)container).getFile((IPath)new Path(fileName)).exists()) {
            this.updateStatus(LocaleMessage.getString("filename.used"));
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(LocaleMessage.getString("project.must.be.writable"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(LocaleMessage.getString("file.name.must.be.specified"));
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(LocaleMessage.getString("file.name.must.be.valid"));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(FILE_EXT)) {
            this.updateStatus(LocaleMessage.getString("file.extension.must.be.bm"));
            return;
        }
        if (this.getSQL().length() == 0) {
            this.updateStatus(LocaleMessage.getString("sql.must.be.specified"));
            return;
        }
        this.updateStatus(null);
    }

    public void setFolder(String path) {
        this.containerText.setText(path);
    }

    public void setFileName(String fileName) {
        this.fileText.setText(fileName);
    }

    public StyledText getSQLTextField() {
        return this.innerText;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        String fileName = this.fileText.getText();
        if (fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + "." + FILE_EXT;
        }
        return fileName;
    }

    public String getSQL() {
        return this.innerText.getText();
    }
}

