/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.procedure;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.wizard.procedure.OracleParameter;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.helpers.SystemException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class OracleProcedureObject {
    public static final String SPACES = " ";
    public String object_name;
    public String procedure_name;
    public int subprogram_id;
    public String object_type;
    public List parameters;
    public static Map typeMap = new HashMap();
    public static Map parameterMap = new HashMap();

    static {
        typeMap.put("PLS_INTEGER", "java.lang.Long");
        typeMap.put("BOOLEAN", "java.lang.Boolean");
        typeMap.put("NUMBER", "java.lang.Long");
        typeMap.put("INTEGER", "java.lang.Long");
        typeMap.put("CLOB", "java.sql.Clob");
        typeMap.put("DATE", "java.util.Date");
        typeMap.put("VARCHAR2", "java.lang.String");
        parameterMap.put("company_id", "/session/@company_id");
        parameterMap.put("user_id", "/session/@user_id");
        parameterMap.put("session_id", "/session/@session_id");
    }

    public OracleProcedureObject(String objectName, String procedureName, int subprogramId, String objectType) {
        this.object_name = objectName;
        this.procedure_name = procedureName;
        this.subprogram_id = subprogramId;
        this.object_type = objectType;
    }

    public String getObject_name() {
        return this.object_name;
    }

    public void setObject_name(String objectName) {
        this.object_name = objectName;
    }

    public String getProcedure_name() {
        return this.procedure_name;
    }

    public void setProcedure_name(String procedureName) {
        this.procedure_name = procedureName;
    }

    public int getSubprogram_id() {
        return this.subprogram_id;
    }

    public void setSubprogram_id(int subprogramId) {
        this.subprogram_id = subprogramId;
    }

    public String getObject_type() {
        return this.object_type;
    }

    public void setObject_type(String objectType) {
        this.object_type = objectType;
    }

    public void addParameter(OracleParameter parameter) {
        this.parameters.add(parameter);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    public String toText() throws ApplicationException {
        if (this.parameters == null) {
            this.initParameters();
        }
        String objectType = "procedure";
        if (this.parameters.size() <= 0) {
            return String.valueOf(objectType) + SPACES + this.getFullObjectName();
        }
        StringBuffer sb = new StringBuffer("");
        boolean firstRecord = true;
        String return_string = null;
        for (OracleParameter para : this.parameters) {
            if (para.getPosition() == 0) {
                objectType = "function";
                return_string = " return " + para.getPls_type();
                continue;
            }
            if (firstRecord) {
                sb.append("(\r\n");
                firstRecord = false;
            } else {
                sb.append(",\r\n");
            }
            sb.append(para.getName()).append(SPACES).append(para.getIn_out()).append(SPACES).append(para.getPls_type());
        }
        if (!firstRecord) {
            sb.append(")\r\n");
        }
        if (return_string != null) {
            sb.append(return_string);
        }
        return String.valueOf(objectType) + SPACES + this.getFullObjectName() + sb.toString();
    }

    public CompositeMap toCompositeMap() throws ApplicationException {
        if (this.parameters == null) {
            this.initParameters();
        }
        String pre = "bm";
        CommentCompositeMap model = new CommentCompositeMap(pre, "http://www.aurora-framework.org/schema/bm", "model");
        CommentCompositeMap operations = new CommentCompositeMap(pre, "http://www.aurora-framework.org/schema/bm", "operations");
        model.addChild(operations);
        CommentCompositeMap operation = new CommentCompositeMap(pre, "http://www.aurora-framework.org/schema/bm", "operation");
        operations.addChild(operation);
        operation.put("name", "execute");
        if (this.parameters.size() > 0) {
            CommentCompositeMap bm_parameters = new CommentCompositeMap(pre, "http://www.aurora-framework.org/schema/bm", "parameters");
            operation.addChild(bm_parameters);
            for (OracleParameter op : this.parameters) {
                CommentCompositeMap bm_parameter = new CommentCompositeMap(pre, "http://www.aurora-framework.org/schema/bm", "parameter");
                bm_parameter.put("name", this.convertParameter(op.getName()));
                bm_parameter.put("dataType", typeMap.get(op.getPls_type()));
                bm_parameter.put("required", "true");
                bm_parameter.put("input", new Boolean(op.getIn_out().indexOf("IN") != -1));
                bm_parameter.put("output", new Boolean(op.getIn_out().indexOf("OUT") != -1));
                bm_parameters.addChild(bm_parameter);
            }
        }
        CommentCompositeMap update_sql = new CommentCompositeMap(pre, "http://www.aurora-framework.org/schema/bm", "update-sql");
        StringBuffer sb = new StringBuffer("");
        String return_string = "";
        if (this.parameters.size() > 0) {
            boolean firstRecord = true;
            for (OracleParameter para : this.parameters) {
                if (para.getPosition() == 0) {
                    return_string = "${@" + para.getName() + "} := ";
                    continue;
                }
                if (firstRecord) {
                    sb.append(String.valueOf(this.newLine(5)) + "(" + this.newLine(6));
                    firstRecord = false;
                } else {
                    sb.append("," + this.newLine(6));
                }
                sb.append(para.getName().toLowerCase()).append("=>").append("${").append(this.convertParameterForUse(para.getName())).append("}");
            }
            if (!firstRecord) {
                sb.append(String.valueOf(this.newLine(5)) + ")");
            }
        }
        sb.append(";" + this.newLine(4));
        String text = String.valueOf(this.newLine(4)) + "begin" + this.newLine(5) + return_string + this.getFullObjectName() + sb.toString() + "end;";
        update_sql.setText(text);
        operation.addChild(update_sql);
        return model;
    }

    private String newLine(int level) {
        StringBuffer sb = new StringBuffer(AuroraResourceUtil.LineSeparator);
        int i = 0;
        while (i < level) {
            sb.append("    ");
            ++i;
        }
        return sb.toString();
    }

    public String convertParameter(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        int index = parameterName.indexOf("_");
        String convertpn = parameterName;
        if (index != -1) {
            String pre = parameterName.substring(0, index);
            if (pre.toLowerCase().equals("p") || pre.toLowerCase().equals("v")) {
                convertpn = parameterName.substring(index + 1).toLowerCase();
            } else if (pre.toLowerCase().equals("pi") || pre.toLowerCase().equals("po")) {
                convertpn = parameterName.substring(index + 2).toLowerCase();
            }
        }
        return convertpn.toLowerCase();
    }

    public String convertParameterForUse(String parameterName) {
        String pn = this.convertParameter(parameterName);
        Object mappn = parameterMap.get(pn);
        if (mappn != null) {
            return (String)mappn;
        }
        if (pn.indexOf("@") == -1) {
            return "@" + pn;
        }
        return pn;
    }

    public String getFullObjectName() {
        String fullObjectName = this.object_name;
        if (this.procedure_name != null && !"".equals(this.procedure_name)) {
            fullObjectName = String.valueOf(fullObjectName) + "." + this.procedure_name;
        }
        return fullObjectName;
    }

    public void initParameters() throws ApplicationException {
        this.parameters = new LinkedList();
        Connection connection = DBConnectionUtil.getDBConnectionSyncExec(ProjectUtil.getIProjectFromSelection());
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            try {
                String select_sql = "select a.argument_name,a.position,a.pls_type,a.in_out from user_arguments a where a.object_name = ? and a.package_name = ?  and a.subprogram_id = ?  order by a.position";
                st = connection.prepareStatement(select_sql);
                st.setString(1, this.procedure_name);
                st.setString(2, this.object_name);
                st.setInt(3, this.subprogram_id);
                rs = st.executeQuery();
                while (rs.next()) {
                    String argument_name = rs.getString(1);
                    if ((argument_name == null || "".equals(argument_name)) && rs.getInt(2) != 0) continue;
                    if (argument_name == null || "".equals(argument_name)) {
                        argument_name = "return_value";
                    }
                    this.parameters.add(new OracleParameter(argument_name, rs.getInt(2), rs.getString(3), rs.getString(4)));
                }
            }
            catch (SQLException e) {
                throw new SystemException(e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    st.close();
                }
                catch (SQLException e) {
                    throw new SystemException(e);
                }
            }
        }
    }
}

