/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.procedure;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.wizard.procedure.OracleProcedureObject;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.SystemException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uncertain.composite.CompositeMap;

public class BMFromProcedurePage
extends WizardPage {
    private final String[] columnNames = new String[]{"object_name", "procedure_name", "subprogram_id", "overload", "object_type"};
    private final String[] columnTitles = new String[]{"\u5bf9\u8c61", "\u8fc7\u7a0b", "\u987a\u5e8f", "\u91cd\u8f7d", "\u7c7b\u578b"};
    public static final String FILE_EXT = "bm";
    private Button overwriteButton;
    private CTabFolder tabFolder;
    private OracleProcedureObject focusObject;
    private IProject project;
    private GridViewer gridViewer;
    private CompositeMap data;

    public BMFromProcedurePage(IProject project) {
        super("wizardPage");
        this.project = project;
        this.setTitle(LocaleMessage.getString("business.model.editor.file"));
        this.setDescription(LocaleMessage.getString("bm.wizard.desc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.tabFolder = new CTabFolder(container, 2816);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 400;
        this.tabFolder.setLayoutData((Object)gd);
        this.gridViewer = new GridViewer(this.columnNames, 18);
        try {
            this.gridViewer.setFilterColumn("object_name");
            this.gridViewer.setColumnTitles(this.columnTitles);
            this.gridViewer.createViewer((Composite)this.tabFolder);
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            monitor.beginTask(LocaleMessage.getString("\u6b63\u5728\u83b7\u53d6\u6570\u636e\u5e93\u8fc7\u7a0b,\u8bf7\u7a0d\u7b49.."), -1);
                            BMFromProcedurePage.this.data = BMFromProcedurePage.this.getProcedures();
                        }
                        catch (ApplicationException e) {
                            DialogUtil.showExceptionMessageBox(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, true, op);
            this.gridViewer.setData(this.data);
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        CTabItem list = new CTabItem(this.tabFolder, 256);
        list.setText("   \u5bf9\u8c61\u5217\u8868   ");
        list.setControl(this.gridViewer.getControl());
        final CTabItem deteil = new CTabItem(this.tabFolder, 256);
        deteil.setText("   \u660e\u7ec6   ");
        deteil.setControl(this.gridViewer.getControl());
        final StyledText content = new StyledText((Composite)this.tabFolder, 576);
        content.setFont(new Font((Device)this.tabFolder.getDisplay(), "Courier New", 10, 0));
        content.setEditable(false);
        deteil.setControl((Control)content);
        this.gridViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompositeMap record = BMFromProcedurePage.this.gridViewer.getFocus();
                if (record != null) {
                    BMFromProcedurePage.this.focusObject = new OracleProcedureObject(record.getString((Object)"object_name"), record.getString((Object)"procedure_name"), record.getInt((Object)"subprogram_id"), record.getString((Object)"object_type"));
                } else {
                    BMFromProcedurePage.this.focusObject = null;
                }
            }
        });
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (deteil.equals(e.item)) {
                    if (BMFromProcedurePage.this.focusObject != null) {
                        try {
                            content.setText(BMFromProcedurePage.this.focusObject.toText());
                        }
                        catch (ApplicationException e1) {
                            DialogUtil.showExceptionMessageBox(e1);
                        }
                    } else {
                        content.setText("\u6ca1\u6709\u9009\u62e9\u5bf9\u8c61");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tabFolder.setSelection(0);
        this.overwriteButton = new Button(container, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.overwriteButton.setLayoutData((Object)gd);
        this.overwriteButton.setText("\u91cd\u540d\u65f6,\u662f\u5426\u8986\u76d6?");
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public OracleProcedureObject getSelectionObject() {
        return this.focusObject;
    }

    public CompositeMap getSelection() {
        return this.gridViewer.getSelection();
    }

    public void setSelectionObject(OracleProcedureObject selectionObject) {
        this.focusObject = selectionObject;
    }

    private void initialize() {
    }

    private void dialogChanged() {
        if (!this.project.isAccessible()) {
            this.updateStatus(LocaleMessage.getString("project.must.be.writable"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean isOverwrite() {
        return this.overwriteButton.getSelection();
    }

    public CompositeMap getProcedures() throws ApplicationException {
        Connection connection = DBConnectionUtil.getDBConnectionSyncExec(this.project);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = connection.createStatement();
            String select_sql = "select t.object_name, t.procedure_name, t.subprogram_id,t.overload, t.object_type from user_procedures t  where t.subprogram_id <> 0  order by t.object_name, t.subprogram_id ";
            rs = st.executeQuery(select_sql);
            CommentCompositeMap records = new CommentCompositeMap("records");
            while (rs.next()) {
                CommentCompositeMap record = new CommentCompositeMap("record");
                record.put("object_name", rs.getString(1));
                record.put("procedure_name", rs.getString(2));
                record.put("subprogram_id", new Integer(rs.getInt(3)));
                record.put("overload", rs.getString(4));
                record.put("object_type", rs.getString(5));
                records.addChild(record);
            }
            CommentCompositeMap commentCompositeMap = records;
            return commentCompositeMap;
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    st.close();
                }
                catch (SQLException e) {
                    throw new SystemException(e);
                }
            }
        }
    }
}

