/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor.toolbar.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.dialog.ParamQueryDialog;
import aurora.ide.editor.core.ISqlViewer;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExecuteSqlAction
extends Action {
    ISqlViewer viewer;

    public ExecuteSqlAction(ISqlViewer viewer) {
        this.viewer = viewer;
    }

    public ExecuteSqlAction(ISqlViewer viewer, ImageDescriptor imageDescriptor, String text) {
        if (imageDescriptor != null) {
            this.setHoverImageDescriptor(imageDescriptor);
        }
        if (text != null) {
            this.setText(text);
        }
        this.viewer = viewer;
    }

    public void run() {
        Connection conn = this.viewer.getConnection();
        String sql = this.viewer.getSql().trim();
        if (sql == null || "".equals(sql)) {
            DialogUtil.showErrorMessageBox("\u8bf7\u5148\u8f93\u5165SQL\u8bed\u53e5\u3002");
            return;
        }
        String[] parameters = new String[]{};
        if (sql.indexOf(36) != -1) {
            sql = sql.replaceAll("\r\n|\r|\n", " ");
            sql = sql.replace("@", "");
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ParamQueryDialog dialog = new ParamQueryDialog(shell, sql);
            if (dialog.open() == 0) {
                sql = sql.replaceAll("\\$\\{[^:}]+\\}", "?");
                String[] stringArray = parameters = dialog.getValues();
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s != null && s.indexOf("~") != -1) {
                        sql = sql.replaceFirst("\\$\\{[^}]+\\}", s.substring(1));
                    }
                    ++n2;
                }
            } else {
                return;
            }
        }
        String action = sql.trim().split(" ")[0];
        ResultSet resultSet = null;
        PreparedStatement stmt = null;
        int resultCount = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                int i = 0;
                int n = 0;
                while (i < parameters.length) {
                    if (parameters[i] == null) {
                        stmt.setString(n + 1, parameters[i]);
                        ++n;
                    } else if (parameters[i].indexOf("~") == -1) {
                        stmt.setString(n + 1, parameters[i]);
                        ++n;
                    }
                    ++i;
                }
                if ("select".equalsIgnoreCase(action)) {
                    resultSet = stmt.executeQuery();
                } else if (action != null) {
                    resultCount = stmt.executeUpdate();
                }
                if (resultSet != null) {
                    resultCount = resultSet.getFetchSize();
                }
                this.viewer.refresh(resultSet, resultCount);
            }
            catch (SQLException e) {
                DialogUtil.showExceptionMessageBox(e);
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    e2.printStackTrace();
                }
                return;
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    public static ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("run.icon"));
    }
}

