/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor;

import aurora.bm.BusinessModel;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.ExtendModelFactory;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.ProjectionReconcile;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.textpage.XMLConfiguration;
import aurora.ide.editor.textpage.XmlErrorReconcile;
import aurora.ide.editor.textpage.XmlReconcilingStrategy;
import aurora.ide.search.cache.CacheManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.FormEditor;
import uncertain.composite.CompositeMap;
import uncertain.ocm.OCManager;

public class ViewSource
extends TextPage {
    public ViewSource(FormEditor editor) {
        super(editor);
        this.setSourceViewerConfiguration(new XMLConfiguration(new ColorManager()){

            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                XmlReconcilingStrategy strategy = new XmlReconcilingStrategy(sourceViewer);
                strategy.addListener(new XmlErrorReconcile(sourceViewer));
                strategy.addListener(new ProjectionReconcile((ProjectionViewer)sourceViewer));
                MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
                return reconciler;
            }
        });
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSourceViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                ViewSource.this.refresh();
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    public boolean isDirty() {
        return false;
    }

    public void refresh(boolean bool) {
        this.setModify(false);
    }

    public void refresh() {
        this.getSourceViewer().getTextWidget().setText(this.getExtendContent());
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    protected void createActions() {
    }

    public String getExtendContent() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        try {
            CompositeMap wholeBMCompositeMap = CacheManager.getWholeBMCompositeMap(file);
            String xml1 = CommentXMLOutputter.defaultInstance().toXML(wholeBMCompositeMap, true);
            return xml1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    protected void createUndoRedoActions() {
    }

    private BusinessModel createResult(CompositeMap config, IFile file) {
        ExtendModelFactory factory = new ExtendModelFactory(OCManager.getInstance(), file);
        return factory.getModel(config);
    }
}

