/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.AddFieldAction;
import aurora.ide.bm.editor.AddRefFieldAction;
import aurora.ide.editor.BaseCompositeMapViewer;
import aurora.ide.editor.CompositeMapPage;
import aurora.ide.editor.FixedSizeControlListener;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.PropertyHashViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.RefreshAction;
import aurora.ide.node.action.RemoveElementAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.schema.Array;
import uncertain.schema.Element;
import uncertain.schema.IType;

public class BusinessModelPage
extends CompositeMapPage {
    private static final String PageId = "BusinessModelPage";
    private static final String PageTitle = LocaleMessage.getString("business.model.file");
    private CTabFolder mTabFolder;
    private CompositeMap data;
    private SashForm sashForm;
    private Composite shell;
    private ArrayList childViews;
    private static final String[] customTabs = new String[]{"primary-key", "order-by", "ref-fields"};
    private static final String ref_fields = "ref-fields";
    private List tabFolerNameList;
    private static Map customerTitles = new HashMap();

    static {
        customerTitles.put("fields", "\u5b57\u6bb5");
        customerTitles.put(ref_fields, "\u5f15\u7528\u5b57\u6bb5");
        customerTitles.put("primary-key", "\u4e3b\u952e");
        customerTitles.put("order-by", "\u6392\u5e8f");
        customerTitles.put("relations", "\u5173\u8054");
        customerTitles.put("data-filters", "\u5f3a\u5236\u67e5\u8be2\u6761\u4ef6");
        customerTitles.put("query-fields", "\u53ef\u9009\u67e5\u8be2\u6761\u4ef6");
        customerTitles.put("features", "\u7279\u6027");
        customerTitles.put("operations", "\u81ea\u5b9a\u4e49\u64cd\u4f5c");
    }

    public BusinessModelPage(FormEditor editor) {
        super(editor, PageId, PageTitle);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.shell = form.getBody();
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        Element schemaElement = LoadSchemaManager.getSchemaManager().getElement(AuroraConstant.ModelQN);
        if (schemaElement == null) {
            DialogUtil.showErrorMessageBox(LocaleMessage.getString("please.add.bm.schema.file"));
            return;
        }
        if (this.data == null) {
            String filePath = this.getFile().getAbsolutePath();
            try {
                CompositeLoader loader = AuroraResourceUtil.getCompsiteLoader();
                this.data = loader.loadByFile(filePath);
            }
            catch (IOException e) {
                DialogUtil.logErrorException(e);
                return;
            }
            catch (SAXException e) {
                String emptyExcption = "Premature end of file";
                if (e.getMessage() != null && e.getMessage().indexOf(emptyExcption) != -1) {
                    this.data = BMUtil.createBMTopNode();
                    ((CommentCompositeMap)this.data).setComment("\u672c\u6587\u4ef6\u4e3a\u7a7a,\u73b0\u5728\u5185\u5bb9\u4e3a\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa,\u8bf7\u4fee\u6539\u5e76\u4fdd\u5b58");
                }
                DialogUtil.showExceptionMessageBox(e);
                return;
            }
            if (!this.data.getQName().equals((Object)AuroraConstant.ModelQN)) {
                DialogUtil.showErrorMessageBox("\u6587\u4ef6" + filePath + "\u7684" + LocaleMessage.getString("this.root.element.is.not") + AuroraConstant.ModelQN + " !");
                return;
            }
        }
        try {
            this.createContent(this.shell);
        }
        catch (ApplicationException e) {
            DialogUtil.logErrorException(e);
        }
    }

    protected void createContent(Composite shell) throws ApplicationException {
        Control[] childs = shell.getChildren();
        int i = 0;
        while (i < childs.length) {
            Control temp = childs[i];
            if (!temp.isDisposed()) {
                temp.dispose();
            }
            ++i;
        }
        this.sashForm = new SashForm(shell, 512);
        this.initChildViews();
        this.createMasterContent((Composite)this.sashForm);
        this.createDetailContent((Composite)this.sashForm);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setLayout((Layout)new GridLayout());
        shell.layout(true);
        this.sashForm.setWeights(new int[]{2, 4});
        if (this.getSelectionTab() == null) {
            CompositeMap child = this.data.getChild("operations");
            String init_tab = child == null ? "fields" : "operations";
            this.setSelectionTab(init_tab);
        }
    }

    private void initChildViews() {
        this.tabFolerNameList = new ArrayList();
        if (this.childViews != null) {
            this.childViews.clear();
        } else {
            this.childViews = new ArrayList();
        }
    }

    protected void createMasterContent(Composite parent) throws ApplicationException {
        String desc;
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(768));
        sashForm.setLayout((Layout)new GridLayout(2, false));
        PropertyHashViewer mPropertyEditor = new PropertyHashViewer(this, (Composite)sashForm);
        this.childViews.add(mPropertyEditor);
        mPropertyEditor.createEditor(false);
        String errorMessage = mPropertyEditor.clear(true);
        if (errorMessage != null) {
            DialogUtil.showErrorMessageBox(errorMessage);
        }
        mPropertyEditor.setData(this.data);
        Group bmDescGroup = new Group((Composite)sashForm, 0);
        bmDescGroup.setLayout((Layout)new FillLayout());
        bmDescGroup.setText("\u672cBM\u529f\u80fd\u63cf\u8ff0");
        final StyledText bmDescSt = new StyledText((Composite)bmDescGroup, 2114);
        String bmDesc = "description";
        CompositeMap bmCm = this.data.getChild("description");
        if (bmCm != null && (desc = bmCm.getText()) != null) {
            bmDescSt.setText(desc);
        }
        bmDescSt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeMap bmCm = BusinessModelPage.this.data.getChild("description");
                if (bmCm == null) {
                    bmCm = new CommentCompositeMap(BusinessModelPage.this.data.getPrefix(), BusinessModelPage.this.data.getNamespaceURI(), "description");
                    BusinessModelPage.this.data.addChild(bmCm);
                }
                bmCm.setText(bmDescSt.getText());
                BusinessModelPage.this.refresh(true);
            }
        });
        sashForm.addControlListener((ControlListener)new FixedSizeControlListener(700));
    }

    private void registerTabFolder(int i, String tabFolerName) {
        this.tabFolerNameList.add(i, tabFolerName);
    }

    private void createDetailContent(Composite parent) throws ApplicationException {
        this.mTabFolder = this.createTabFolder(parent);
        this.mTabFolder.setLayoutData((Object)new GridData(768));
        Element model_em = LoadSchemaManager.getSchemaManager().getElement(AuroraConstant.ModelQN);
        Iterator arrays = model_em.getAllArrays().iterator();
        int i = 0;
        while (arrays.hasNext()) {
            IType type;
            Array array = (Array)arrays.next();
            CompositeMap array_data = this.data.getChild(array.getLocalName());
            if (array_data == null) {
                String name = array.getLocalName();
                array_data = new CommentCompositeMap(this.data.getPrefix(), this.data.getNamespaceURI(), name);
                array_data.setParent(this.data);
            }
            if (!((type = array.getElementType()) instanceof Element)) {
                this.childViews.add(this.createBaseViewer(i, array, array_data));
                this.registerTabFolder(i, array.getLocalName());
            } else {
                Element arrayType = LoadSchemaManager.getSchemaManager().getElement(type.getQName());
                if (arrayType.getAllElements().size() > 0) {
                    this.childViews.add(this.createBaseViewer(i, array, array_data));
                    this.registerTabFolder(i, array.getLocalName());
                } else {
                    final GridViewer gridViewer = new GridViewer(null, 8);
                    gridViewer.setParent(this);
                    gridViewer.createViewer((Composite)this.mTabFolder, array_data);
                    int j = 0;
                    while (j < customTabs.length) {
                        if (customTabs[j].equals(array.getLocalName())) {
                            this.createCustomerActions(gridViewer);
                        }
                        ++j;
                    }
                    this.mTabFolder.getItem(i).setText(this.customTabTitle(array.getLocalName()));
                    this.mTabFolder.getItem(i).setControl(gridViewer.getControl());
                    this.childViews.add(gridViewer);
                    this.registerTabFolder(i, array.getLocalName());
                    final int itemIndex = i;
                    this.mTabFolder.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (BusinessModelPage.this.mTabFolder.getSelectionIndex() == itemIndex) {
                                gridViewer.packColumns();
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
            }
            ++i;
        }
        this.mTabFolder.layout(true);
    }

    private BaseCompositeMapViewer createBaseViewer(int i, Array array, CompositeMap array_data) throws ApplicationException {
        BaseCompositeMapViewer baseViewer = new BaseCompositeMapViewer(this, array_data);
        baseViewer.createFormContent((Composite)this.mTabFolder);
        this.mTabFolder.getItem(i).setText(this.customTabTitle(array.getLocalName()));
        this.mTabFolder.getItem(i).setControl(baseViewer.getControl());
        return baseViewer;
    }

    public void createCustomerActions(GridViewer pae) {
        Element element = CompositeMapUtil.getElement(pae.getInput());
        if (element == null) {
            return;
        }
        Action[] actions = new Action[3];
        if (element.isArray()) {
            Action addAction = null;
            addAction = ref_fields.equals(element.getLocalName()) ? new AddRefFieldAction(pae, pae.getInput().getParent(), 2) : new AddFieldAction(pae, this.data.getChild("fields"), pae.getInput());
            actions[0] = addAction;
            actions[1] = new RefreshAction(pae, 2);
            actions[2] = new RemoveElementAction(pae, 2);
            pae.setActions((IAction[])actions);
        }
    }

    private CTabFolder createTabFolder(final Composite parent) {
        final CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setMaximizeVisible(true);
        tabFolder.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (tabFolder.getMaximized()) {
                    tabFolder.setMaximized(false);
                    BusinessModelPage.this.sashForm.setMaximizedControl(null);
                    parent.layout(true);
                } else {
                    tabFolder.setMaximized(true);
                    BusinessModelPage.this.sashForm.setMaximizedControl((Control)tabFolder);
                    parent.layout(true);
                }
            }
        });
        tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event) {
                tabFolder.setMinimized(true);
                tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
                parent.layout(true);
            }

            public void maximize(CTabFolderEvent event) {
                tabFolder.setMaximized(true);
                BusinessModelPage.this.sashForm.setMaximizedControl((Control)tabFolder);
                parent.layout(true);
            }

            public void restore(CTabFolderEvent event) {
                tabFolder.setMaximized(false);
                BusinessModelPage.this.sashForm.setMaximizedControl(null);
                parent.layout(true);
            }
        });
        tabFolder.setSimple(false);
        tabFolder.setTabHeight(23);
        Element model_em = LoadSchemaManager.getSchemaManager().getElement(AuroraConstant.ModelQN);
        int i = 0;
        while (i < model_em.getAllArrays().size()) {
            new CTabItem(tabFolder, 514);
            ++i;
        }
        return tabFolder;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            File file = this.getFile();
            CommentXMLOutputter.saveToFile(file, this.data);
            super.doSave(monitor);
        }
        catch (IOException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public void refresh(boolean dirty) {
        try {
            this.refreshChildViewData();
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        for (Object childViewer : this.childViews) {
            if (!(childViewer instanceof IViewer)) continue;
            IViewer iViewer = (IViewer)childViewer;
            iViewer.refresh(false);
        }
        super.refresh(dirty);
    }

    private void refreshChildViewData() throws ApplicationException {
        if (this.tabFolerNameList == null || this.data == null || this.childViews == null) {
            return;
        }
        Iterator tabIt = this.tabFolerNameList.iterator();
        int index = 0;
        while (tabIt.hasNext()) {
            String tabFolderName = (String)tabIt.next();
            CompositeMap array_data = this.data.getChild(tabFolderName);
            if (array_data == null) {
                IViewer iViewer;
                array_data = new CommentCompositeMap(this.data.getPrefix(), this.data.getNamespaceURI(), tabFolderName);
                array_data.setParent(this.data);
                Object childViewer = this.childViews.get(index + 1);
                if (childViewer == null) continue;
                if (childViewer instanceof BaseCompositeMapViewer) {
                    iViewer = (BaseCompositeMapViewer)childViewer;
                    ((BaseCompositeMapViewer)iViewer).refresh(array_data);
                } else if (childViewer instanceof GridViewer) {
                    iViewer = (GridViewer)childViewer;
                    ((GridViewer)iViewer).setData(array_data);
                }
            }
            ++index;
        }
    }

    public CompositeMap getData() {
        return this.data;
    }

    public void setData(CompositeMap data) {
        this.data = data;
    }

    public void refreshFormContent(CompositeMap content) {
        this.data = content;
        try {
            this.createContent(this.shell);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    public CompositeMap getSelectionTab() {
        int SelectionIndex = this.mTabFolder.getSelectionIndex();
        if (SelectionIndex == -1) {
            return null;
        }
        Object nameObject = this.tabFolerNameList.get(SelectionIndex);
        if (nameObject == null) {
            return null;
        }
        String tabFolderName = (String)nameObject;
        CompositeMap tabFoler = this.data.getChild(tabFolderName);
        return tabFoler;
    }

    public void setSelectionTab(String tabName) {
        if (tabName == null) {
            return;
        }
        int tabIndex = this.tabFolerNameList.indexOf(tabName);
        if (tabIndex == -1 || tabIndex > this.mTabFolder.getItemCount()) {
            return;
        }
        Object view = this.childViews.get(tabIndex + 1);
        if (view == null) {
            return;
        }
        if (view instanceof GridViewer) {
            ((GridViewer)view).packColumns();
        }
        this.mTabFolder.setSelection(tabIndex);
    }

    private String customTabTitle(String tabName) {
        String tabHeighGrab = "      ";
        String tabTitle = tabName;
        Object customTtile = customerTitles.get(tabName);
        if (customTtile != null) {
            tabTitle = (String)customTtile;
        }
        return String.valueOf(tabHeighGrab) + tabTitle + tabHeighGrab;
    }

    public boolean isFormContendCreated() {
        return this.sashForm != null;
    }
}

