/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor;

import aurora.ide.bm.editor.BusinessModelPage;
import aurora.ide.bm.editor.SQLExecutePage;
import aurora.ide.bm.editor.ViewSource;
import aurora.ide.editor.BaseCompositeMapEditor;
import aurora.ide.editor.CompositeMapPage;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.preferencepages.CustomSettingPreferencePage;
import java.io.ByteArrayInputStream;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import uncertain.composite.CompositeMap;

public class BusinessModelEditor
extends BaseCompositeMapEditor {
    protected BusinessModelPage mainFormPage;
    private SQLExecutePage sqlPage = new SQLExecutePage(this);
    private ViewSource viewSource = new ViewSource(this);
    int SQLPageIndex;
    private int viewSourceIndex;

    public CompositeMapPage initMainViewerPage() {
        this.mainFormPage = new BusinessModelPage(this);
        return this.mainFormPage;
    }

    protected void addPages() {
        try {
            super.addPages();
            this.SQLPageIndex = this.addPage((IFormPage)this.sqlPage);
            this.viewSourceIndex = this.addPage((IEditorPart)this.viewSource, this.getEditorInput());
            this.setPageText(this.viewSourceIndex, LocaleMessage.getString("view.source"));
            this.setActivePage(CustomSettingPreferencePage.getBMEditorInitPageIndex());
        }
        catch (PartInitException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        this.sqlPage.setModify(true);
    }

    protected void pageChange(int newPageIndex) {
        int currentPage = this.getCurrentPage();
        super.pageChange(newPageIndex);
        if (newPageIndex == this.SQLPageIndex) {
            try {
                String context = "";
                context = this.mainFormPage.isModify() ? CompositeMapUtil.getFullContent(this.mainFormPage.getData()) : (this.getTextPage().isModify() ? this.getTextPage().getContent() : (this.mainViewerPage.isFormContendCreated() ? CompositeMapUtil.getFullContent(this.mainFormPage.getData()) : this.getTextPage().getContent()));
                this.sqlPage.refresh(context);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        } else if (newPageIndex == this.viewSourceIndex) {
            this.viewSource.refresh();
        } else if (currentPage == this.mainViewerIndex && newPageIndex == this.textPageIndex && this.mainViewerPage.isFormContendCreated()) {
            try {
                this.locateTextPage();
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        } else if (currentPage == this.textPageIndex && newPageIndex == this.mainViewerIndex && this.getTextPage().checkContentFormat()) {
            this.locateMainPage();
        }
    }

    private void locateMainPage() {
        CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
        try {
            ByteArrayInputStream content = new ByteArrayInputStream(this.getTextPage().getContent().getBytes("UTF-8"));
            CompositeMap cm = parser.getCompositeMapFromLine(content, this.getTextPage().getCursorLine());
            if (cm != null) {
                while (cm.getParent() != null) {
                    CompositeMap parent = cm.getParent();
                    if (AuroraConstant.ModelQN.equals((Object)parent.getQName())) {
                        this.mainFormPage.setSelectionTab(cm.getName());
                    }
                    cm = parent;
                }
            }
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    private void locateTextPage() throws ApplicationException {
        CompositeMap selection = this.mainFormPage.getSelectionTab();
        if (selection == null) {
            return;
        }
        int line = 0;
        line = CompositeMapUtil.locateNode(CompositeMapUtil.getFullContent(this.mainFormPage.getData()), selection);
        int offset = this.getTextPage().getOffsetFromLine(line);
        this.getTextPage().setHighlightRange(offset, 10, true);
    }
}

