/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.ListElementsExchangeDialog;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class AddFieldAction
extends Action {
    private IViewer viewer;
    private CompositeMap allFields;
    private CompositeMap target;
    private static final String primary_key = "primary-key";
    private static final String primaryKeyChild = "pk-field";
    private static final String order_by = "order-by";
    private static final String orderField = "order-field";
    private static final String defaultChild = "field";
    private static final String mainAttribute = "name";

    public AddFieldAction(IViewer viewer, CompositeMap source, CompositeMap target) {
        this.viewer = viewer;
        this.allFields = source;
        this.target = target;
        this.setHoverImageDescriptor(AddFieldAction.getDefaultImageDescriptor());
    }

    public void run() {
        if (this.allFields == null) {
            DialogUtil.showErrorMessageBox("\u6ca1\u6709\u53ef\u7528\u7684\u5b57\u6bb5!");
            return;
        }
        List source_childs_list = this.allFields.getChildsNotNull();
        if (source_childs_list.size() == 0) {
            return;
        }
        QualifiedName fieldQN = this.getFieldQN();
        if (fieldQN == null) {
            return;
        }
        List existFields = this.getExistFields();
        List source_array = this.getNotExistFields(source_childs_list, existFields);
        String[] source_items = this.getArrayFromList(source_array);
        String[] target_items = this.getArrayFromList(existFields);
        ListElementsExchangeDialog dialog = new ListElementsExchangeDialog(LocaleMessage.getString("get.fields"), this.allFields.getName(), this.target.getName(), source_items, target_items);
        if (dialog.open() == 1) {
            return;
        }
        String[] result = dialog.getRightItems();
        this.target.getChildsNotNull().clear();
        int i = 0;
        while (i < result.length) {
            CompositeMap newNode = CompositeMapUtil.addElement(this.target, fieldQN);
            newNode.put((Object)mainAttribute, (Object)result[i]);
            ++i;
        }
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    private String[] getArrayFromList(List source_array) {
        String[] source_items = new String[source_array.size()];
        int i = 0;
        while (i < source_array.size()) {
            source_items[i] = (String)source_array.get(i);
            ++i;
        }
        return source_items;
    }

    private List getNotExistFields(List source_childs_list, List existFields) {
        if (source_childs_list == null) {
            return null;
        }
        if (existFields == null) {
            return source_childs_list;
        }
        ArrayList<String> source_array = new ArrayList<String>();
        for (CompositeMap child : source_childs_list) {
            String node = child.getString((Object)mainAttribute);
            if (node == null || existFields.contains(node)) continue;
            source_array.add(node);
        }
        return source_array;
    }

    private List getExistFields() {
        List target_childs_list = this.target.getChildsNotNull();
        ArrayList<String> target_array = new ArrayList<String>();
        for (CompositeMap child : target_childs_list) {
            String targetNode = child.getString((Object)mainAttribute);
            if (targetNode == null) continue;
            target_array.add(targetNode);
        }
        return target_array;
    }

    private QualifiedName getFieldQN() {
        List source_childs_list = this.allFields.getChildsNotNull();
        if (source_childs_list.size() == 0) {
            return null;
        }
        String localName = defaultChild;
        if (primary_key.equals(this.target.getName())) {
            localName = primaryKeyChild;
        } else if (order_by.equals(this.target.getName())) {
            localName = orderField;
        }
        return new QualifiedName(this.allFields.getPrefix(), this.allFields.getNamespaceURI(), localName);
    }

    public static ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("add.icon"));
    }
}

