/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm;

import aurora.bm.BusinessModel;
import aurora.bm.ModelFactory;
import aurora.ide.bm.BMUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.ocm.OCManager;

public class ExtendModelFactory
extends ModelFactory {
    private IFile c_file;

    public ExtendModelFactory(OCManager ocm, IFile file) {
        super(ocm);
        this.c_file = file;
    }

    public CompositeLoader getCompositeLoader() {
        return new CompositeLoader(){

            public CompositeMap loadFromClassPath(String full_name, String file_ext) throws IOException, SAXException {
                try {
                    IFile file = (IFile)BMUtil.getBMResourceFromClassPath(ExtendModelFactory.this.c_file.getProject(), full_name);
                    CompositeMap config = AuroraResourceUtil.loadFromResource((IResource)file);
                    return config;
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    protected BusinessModel getNewModelInstance(String name, String ext) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("model name is null");
        }
        try {
            IFile file = (IFile)BMUtil.getBMResourceFromClassPath(this.c_file.getProject(), name);
            CompositeMap config = AuroraResourceUtil.loadFromResource((IResource)file);
            if (config == null) {
                throw new IOException("Can't load resource " + name);
            }
            BusinessModel model = this.createBusinessModelInternal(config);
            model.setName(name);
            return model;
        }
        catch (ApplicationException e) {
            e.printStackTrace();
            throw new RuntimeException("Error when parsing " + name, e);
        }
    }
}

