/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.search.cache.CacheManager;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import uncertain.composite.CompositeMap;

public class BMUtil {
    public static final String ExtendAttrName = "extend";
    public static final String BMPrefix = "bm";
    public static final String FeaturesUri = "aurora.database.features";
    public static final String FeaturesPrefix = "f";
    public static final String OracleUri = "aurora.database.local.oracle";
    public static final String OraclePrefix = "ora";

    public static IResource getBMResourceFromClassPath(String classPath, String fileExt) throws ApplicationException {
        return BMUtil.getBMResourceFromClassPath(ProjectUtil.getIProjectFromSelection(), classPath, fileExt);
    }

    public static IResource getBMResourceFromClassPath(IProject project, String classPath, String fileExt) throws ApplicationException {
        if (classPath == null || project == null) {
            return null;
        }
        String path = String.valueOf(classPath.replace('.', File.separatorChar)) + '.' + fileExt;
        String fullPath = String.valueOf(ProjectUtil.getBMHome(project)) + File.separatorChar + path;
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
        return file;
    }

    public static IResource getBMResourceFromClassPath(String classPath) throws ApplicationException {
        return BMUtil.getBMResourceFromClassPath(ProjectUtil.getIProjectFromSelection(), classPath);
    }

    public static IResource getBMResourceFromClassPath(IProject project, String classPath) throws ApplicationException {
        if (classPath == null || project == null) {
            return null;
        }
        String path = String.valueOf(classPath.replace('.', File.separatorChar)) + '.' + BMPrefix;
        String fullPath = String.valueOf(ProjectUtil.getBMHome(project)) + File.separatorChar + path;
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
        return file;
    }

    public static String getBMDescription(IResource file) throws ApplicationException {
        if (file == null) {
            return null;
        }
        CompositeMap bm = AuroraResourceUtil.loadFromResource(file);
        String bmDescNodeName = "description";
        if (bm == null) {
            return null;
        }
        if (!bm.getQName().getLocalName().equals(AuroraConstant.ModelQN.getLocalName())) {
            throw new ApplicationException("\u6587\u4ef6:" + file.getFullPath().toOSString() + "\u7684" + LocaleMessage.getString("this.root.element.is.not") + AuroraConstant.ModelQN + " !");
        }
        CompositeMap bmCm = bm.getChild("description");
        if (bmCm != null) {
            return bmCm.getText();
        }
        return null;
    }

    public static CompositeMap getFieldsFromBM(CompositeMap modelNode) {
        if (modelNode == null) {
            return null;
        }
        BusinessModel model = BusinessModel.getInstance((CompositeMap)modelNode);
        String prefix = CompositeMapUtil.getContextFullName(modelNode, AuroraConstant.FieldsQN);
        CommentCompositeMap fieldsNode = new CommentCompositeMap(prefix, AuroraConstant.FieldsQN.getNameSpace(), AuroraConstant.FieldsQN.getLocalName());
        Field[] fields = model.getFields();
        if (fields == null || fields.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fields.length) {
            CompositeMap fieldNode = fields[i].getObjectContext();
            fieldsNode.addChild(fieldNode);
            ++i;
        }
        return fieldsNode;
    }

    public static CompositeMap getFieldsFromBMPath(String classPath) throws ApplicationException {
        CompositeMap modelNode = AuroraResourceUtil.loadFromResource(BMUtil.getBMResourceFromClassPath(classPath));
        if (modelNode == null) {
            return null;
        }
        return BMUtil.getFieldsFromBM(modelNode);
    }

    public static CompositeMap getFieldsFromDS(CompositeMap dataSet) throws ApplicationException {
        if (dataSet == null) {
            return null;
        }
        CompositeMap fields = dataSet.getChild("fields");
        if (fields != null && fields.getChilds() != null && fields.getChilds().size() > 0) {
            return fields;
        }
        String classPath = dataSet.getString((Object)"model");
        if (classPath == null) {
            return null;
        }
        return BMUtil.getFieldsFromBMPath(classPath);
    }

    public static CompositeMap createBMTopNode() {
        CommentCompositeMap model = new CommentCompositeMap(BMPrefix, AuroraConstant.ModelQN.getNameSpace(), AuroraConstant.ModelQN.getLocalName());
        return model;
    }

    public static String getExtendValue(IResource bmFile) throws ApplicationException {
        if (bmFile == null) {
            throw new ApplicationException(bmFile + "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CompositeMap bmData = null;
        try {
            bmData = CacheManager.getCompositeMap((IFile)bmFile);
            String extendValue = bmData.getString((Object)ExtendAttrName);
            return extendValue;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

