/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.javascript;

import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.StringLiteral;

public class JavascriptRhino {
    private String source;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public JavascriptRhino(String source) {
        this.setSource(source);
    }

    public AstRoot createAST() {
        Parser p = new Parser();
        AstRoot parse = p.parse(this.source == null ? "" : this.source, "line", 1);
        return parse;
    }

    public String getLiteralValue(StringLiteral sl) {
        return sl.getValue();
    }

    public String getFirstFunctionName() {
        try {
            AstRoot ast = this.createAST();
            FunctionNodeVisitor v = new FunctionNodeVisitor();
            ast.visit((NodeVisitor)v);
            if (v.fNode != null) {
                return v.fNode.getFunctionName().getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private class FunctionNodeVisitor
    implements NodeVisitor {
        FunctionNode fNode;

        private FunctionNodeVisitor() {
        }

        public boolean visit(AstNode node) {
            if (node instanceof FunctionNode) {
                this.fNode = (FunctionNode)node;
                return false;
            }
            return true;
        }
    }
}

