/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal.contentdetect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ContentDetectHelper {
    public static final int NO_STATE = -1;
    private static final String EXTENSION_COUNT_XML = "extensionCount.xml";
    private static final String EXTENSION_NAMES_XML = "extensionNames.xml";
    private static final String INTROCOUNT = "introcount";
    private static final String CONTRIBUTOR = "contributor";
    private static final String NAME = "name";
    private static final String ROOT = "root";
    private static final String PLUGIN_ID = "aurora.ide.prototype.consultant.product";
    private File configurationDirectory;

    private File getConfigurationLocation() {
        URL configURL;
        Location location;
        if (this.configurationDirectory == null && (location = Platform.getConfigurationLocation()) != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith("file")) {
            this.configurationDirectory = new File(configURL.getFile(), PLUGIN_ID);
            if (this.configurationDirectory != null && !this.configurationDirectory.exists()) {
                this.configurationDirectory.mkdirs();
            }
        }
        return this.configurationDirectory;
    }

    public void saveExtensionCount(int count) {
        XMLMemento writeMemento = XMLMemento.createWriteRoot((String)ROOT);
        writeMemento.putInteger(INTROCOUNT, count);
        this.saveMemento(writeMemento, EXTENSION_COUNT_XML);
    }

    public int getExtensionCount() {
        XMLMemento readMemento = this.getReadMemento(EXTENSION_COUNT_XML);
        if (readMemento == null) {
            return -1;
        }
        Integer extensionCount = readMemento.getInteger(INTROCOUNT);
        if (extensionCount == null) {
            return -1;
        }
        return extensionCount;
    }

    public void saveContributors(Set contributors) {
        XMLMemento writeMemento = XMLMemento.createWriteRoot((String)ROOT);
        Iterator iter = contributors.iterator();
        while (iter.hasNext()) {
            IMemento childMemento = writeMemento.createChild(CONTRIBUTOR);
            childMemento.putString(NAME, (String)iter.next());
        }
        this.saveMemento(writeMemento, EXTENSION_NAMES_XML);
    }

    public Set getContributors() {
        HashSet<String> contributors = new HashSet<String>();
        XMLMemento readMemento = this.getReadMemento(EXTENSION_NAMES_XML);
        if (readMemento == null) {
            return contributors;
        }
        IMemento[] children = readMemento.getChildren(CONTRIBUTOR);
        int c = 0;
        while (c < children.length) {
            contributors.add(children[c].getString(NAME));
            ++c;
        }
        return contributors;
    }

    private XMLMemento getReadMemento(String filename) {
        XMLMemento memento;
        block18: {
            InputStreamReader reader = null;
            try {
                File stateFile = this.getStateFile(filename);
                FileInputStream input = new FileInputStream(stateFile);
                reader = new InputStreamReader((InputStream)input, "utf-8");
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                memento = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block18;
                }
                catch (IOException iOException) {}
                break block18;
            }
            catch (Exception exception) {
                try {
                    memento = null;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block18;
                }
                catch (IOException iOException) {}
                break block18;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return memento;
    }

    private void saveMemento(XMLMemento memento, String filename) {
        block14: {
            File stateFile = this.getStateFile(filename);
            OutputStreamWriter writer = null;
            try {
                try {
                    FileOutputStream stream = new FileOutputStream(stateFile);
                    writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
                    memento.save((Writer)writer);
                }
                catch (IOException iOException) {
                    stateFile.delete();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File getStateFile(String filename) {
        if (this.getConfigurationLocation() == null) {
            return null;
        }
        File stateFile = new File(this.getConfigurationLocation(), filename);
        return stateFile;
    }

    public Set findNewContributors(Set contributors, Set previousContributors) {
        HashSet result = new HashSet(contributors);
        Iterator iter = previousContributors.iterator();
        while (iter.hasNext()) {
            result.remove(iter.next());
        }
        return result;
    }

    public void deleteStateFiles() {
        try {
            File stateFile = new File(this.getConfigurationLocation(), EXTENSION_COUNT_XML);
            stateFile.delete();
            stateFile = new File(this.getConfigurationLocation(), EXTENSION_NAMES_XML);
            stateFile.delete();
        }
        catch (RuntimeException runtimeException) {}
    }
}

