/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.WebSettingsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartsStrip {
    static boolean save = true;
    static boolean flatOpcXmlOutput = false;
    static boolean overwriteInputFile = true;
    static String dir = String.valueOf(System.getProperty("user.dir")) + "/test-strip/";
    static String file = null;
    static boolean stripPropertiesParts = true;
    static boolean keepStyles = true;
    static boolean defaultToDelete = false;
    private static Logger log = LoggerFactory.getLogger(PartsStrip.class);

    public static void main(String[] args) throws Exception {
        if (file == null) {
            File[] filesAndDirs;
            ArrayList<File> filesToProcess = new ArrayList<File>();
            File[] fileArray = filesAndDirs = new File(dir).listFiles();
            int n = filesAndDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(".docx")) {
                    filesToProcess.add(file);
                }
                ++n2;
            }
            for (File file : filesToProcess) {
                String outputfilepath = null;
                if (save && overwriteInputFile) {
                    outputfilepath = file.getAbsolutePath();
                }
                PartsStrip.processFile(file, outputfilepath);
            }
        } else {
            String inputfilepath = String.valueOf(dir) + file + ".docx";
            String outputfilepath = null;
            if (save) {
                outputfilepath = overwriteInputFile ? inputfilepath : (flatOpcXmlOutput ? String.valueOf(dir) + file + "_OUT.xml" : String.valueOf(dir) + file + "_OUT.docx");
            }
            PartsStrip.processFile(new File(inputfilepath), outputfilepath);
        }
    }

    private static void processFile(File inputfile, String outputfilepath) throws Docx4JException {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)inputfile);
        RelationshipsPart rp = wordMLPackage.getRelationshipsPart();
        StringBuilder sb = new StringBuilder();
        PartsStrip.printInfo((Part)rp, sb, "");
        PartsStrip.traverseRelationships(wordMLPackage, rp, sb, "    ");
        System.out.println(sb.toString());
        if (save) {
            wordMLPackage.save(new File(outputfilepath));
            System.out.println("Saved stripped to " + outputfilepath);
        } else {
            System.out.println("Stripped parts from " + inputfile.getName());
        }
    }

    public static void printInfo(Part p, StringBuilder sb, String indent) {
        sb.append("\n" + indent + p.getPartName() + " [" + p.getClass().getName() + "] ");
    }

    public static void traverseRelationships(WordprocessingMLPackage wordMLPackage, RelationshipsPart rp, StringBuilder sb, String indent) throws Docx4JException {
        ArrayList<Relationship> deletions = new ArrayList<Relationship>();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.info("For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget());
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                sb.append("\n" + indent + "external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            try {
                String resolvedPartUri = URIHelper.resolvePartUri((URI)rp.getSourceURI(), (URI)new URI(r.getTarget())).toString();
                resolvedPartUri = resolvedPartUri.substring(1);
                Part part = rp.getPart(r);
                if (part != null) {
                    PartsStrip.printInfo(part, sb, indent);
                }
                if (part == null) {
                    sb.append("Part " + resolvedPartUri + " not found! \n");
                    continue;
                }
                if (part instanceof ThemePart || part instanceof NumberingDefinitionsPart || part instanceof FontTablePart) {
                    deletions.add(r);
                    sb.append(".. DELETED");
                    continue;
                }
                if (part instanceof StyleDefinitionsPart) {
                    if (!keepStyles) {
                        deletions.add(r);
                        sb.append(".. DELETED");
                        continue;
                    }
                    sb.append(".. KEEPING");
                    continue;
                }
                if (stripPropertiesParts && (part instanceof DocPropsExtendedPart || part instanceof DocPropsCorePart || part instanceof DocPropsCustomPart || part instanceof WebSettingsPart || part instanceof DocumentSettingsPart)) {
                    deletions.add(r);
                    sb.append(".. DELETED");
                    continue;
                }
                if (part instanceof MainDocumentPart || part instanceof StyleDefinitionsPart || part instanceof HeaderPart) {
                    sb.append(".. KEEPING");
                    if (part.getRelationshipsPart() == null) {
                        sb.append(".. no rels");
                        continue;
                    }
                    PartsStrip.traverseRelationships(wordMLPackage, part.getRelationshipsPart(), sb, String.valueOf(indent) + "    ");
                    continue;
                }
                if (!defaultToDelete) continue;
                deletions.add(r);
                sb.append(".. DELETED");
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
        for (Relationship r : deletions) {
            rp.removeRelationship(r);
        }
    }
}

