/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.samples.AbstractSample;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;

public class ConvertOutPDF
extends AbstractSample {
    static boolean saveFO;
    static final String sampleText = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /></w:rPr><w:t xml:space=\"preserve\">${fontname}</w:t></w:r></w:p>";
    static final String sampleTextBold = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /><w:b /></w:rPr><w:t>${fontname} bold;</w:t></w:r></w:p>";
    static final String sampleTextItalic = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /><w:i /></w:rPr><w:t>${fontname} italic; </w:t></w:r></w:p>";
    static final String sampleTextBoldItalic = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /><w:b /><w:i /></w:rPr><w:t>${fontname} bold italic</w:t></w:r></w:p>";

    static {
        inputfilepath = null;
        saveFO = false;
    }

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage;
        try {
            ConvertOutPDF.getInputFilePath((String[])args);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        System.out.println(inputfilepath);
        String regex = null;
        PhysicalFonts.setRegex(regex);
        if (inputfilepath == null) {
            wordMLPackage = WordprocessingMLPackage.createPackage();
            ConvertOutPDF.createContent(wordMLPackage.getMainDocumentPart());
        } else {
            wordMLPackage = WordprocessingMLPackage.load((File)new File(inputfilepath));
        }
        Object o = wordMLPackage.getMainDocumentPart().getContent().get(0);
        if (o instanceof P && ((P)o).getPPr() != null) {
            PPr pPr = ((P)o).getPPr();
            BooleanDefaultTrue val = new BooleanDefaultTrue();
            val.setVal(Boolean.FALSE);
            pPr.setPageBreakBefore(val);
        }
        IdentityPlusMapper fontMapper = new IdentityPlusMapper();
        wordMLPackage.setFontMapper((Mapper)fontMapper);
        PhysicalFont font = (PhysicalFont)PhysicalFonts.getPhysicalFonts().get("Comic Sans MS");
        fontMapper.getFontMappings().put("Algerian", font);
        Conversion c = new Conversion(wordMLPackage);
        if (saveFO) {
            c.setSaveFO(new File(String.valueOf(inputfilepath) + ".fo"));
        }
        String outputfilepath = inputfilepath == null ? String.valueOf(System.getProperty("user.dir")) + "/OUT_FontContent.pdf" : String.valueOf(inputfilepath) + ".pdf";
        FileOutputStream os = new FileOutputStream(outputfilepath);
        c.output((OutputStream)os, new PdfSettings());
        System.out.println("Saved " + outputfilepath);
    }

    public static void createContent(MainDocumentPart wordDocumentPart) {
        try {
            PhysicalFonts.discoverPhysicalFonts();
            Map physicalFontMap = PhysicalFonts.getPhysicalFonts();
            Iterator physicalFontMapIterator = physicalFontMap.entrySet().iterator();
            while (physicalFontMapIterator.hasNext()) {
                Map.Entry pairs = physicalFontMapIterator.next();
                if (pairs.getKey() == null) {
                    pairs = physicalFontMapIterator.next();
                }
                String fontName = (String)pairs.getKey();
                PhysicalFont pf = (PhysicalFont)pairs.getValue();
                System.out.println("Added paragraph for " + fontName);
                ConvertOutPDF.addObject(wordDocumentPart, sampleText, fontName);
                PhysicalFont pfVariation = PhysicalFonts.getBoldForm((PhysicalFont)pf);
                if (pfVariation != null) {
                    ConvertOutPDF.addObject(wordDocumentPart, sampleTextBold, pfVariation.getName());
                }
                if ((pfVariation = PhysicalFonts.getBoldItalicForm((PhysicalFont)pf)) != null) {
                    ConvertOutPDF.addObject(wordDocumentPart, sampleTextBoldItalic, pfVariation.getName());
                }
                if ((pfVariation = PhysicalFonts.getItalicForm((PhysicalFont)pf)) == null) continue;
                ConvertOutPDF.addObject(wordDocumentPart, sampleTextItalic, pfVariation.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void addObject(MainDocumentPart wordDocumentPart, String template, String fontName) throws JAXBException {
        HashMap<String, String> substitution = new HashMap<String, String>();
        substitution.put("fontname", fontName);
        Object o = XmlUtils.unmarshallFromTemplate((String)template, substitution);
        wordDocumentPart.addObject(o);
    }
}

